/*
 * Decompiled with CFR 0.152.
 */
package puzzleboard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

class BoardView
extends JPanel
implements MouseListener {
    static final int HOLE = 0;
    private static final Font FONT = new Font("Times", 0, 40);
    private final int size;
    private double colWdt = 0.0;
    private double rowHgt = 0.0;
    private int[][] tile;
    private int number = 0;

    BoardView(int n) {
        this.size = n;
        this.setBackground(Color.black);
        this.tile = new int[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.tile[i][j] = 0;
            }
        }
        this.setEnabled(false);
        this.addMouseListener(this);
    }

    void setNumber(int n, int n2, int n3) {
        if (n3 >= 0 && n3 < this.size * this.size) {
            this.tile[n - 1][n2 - 1] = n3;
        }
    }

    int getNumber(int n, int n2) {
        return this.tile[n - 1][n2 - 1];
    }

    synchronized int get() {
        this.setEnabled(true);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.number;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.ORANGE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.fillRect((int)(0.03 * (double)this.getWidth()), (int)(0.03 * (double)this.getHeight()), (int)(0.94 * (double)this.getWidth()), (int)(0.94 * (double)this.getHeight()));
        this.colWdt = 0.92 * (double)this.getWidth() / (double)this.size;
        this.rowHgt = 0.92 * (double)this.getHeight() / (double)this.size;
        for (int i = 0; i < this.size; ++i) {
            int n = (int)(0.04 * (double)this.getHeight() + (double)i * this.rowHgt);
            for (int j = 0; j < this.size; ++j) {
                int n2 = (int)(0.04 * (double)this.getWidth() + (double)j * this.colWdt);
                if (this.tile[i][j] == 0) continue;
                graphics.setColor(Color.ORANGE);
                graphics.fillRect(n2 + 2, n + 2, (int)this.colWdt - 4, (int)this.rowHgt - 4);
                int n3 = (int)(0.5 * this.colWdt) - (this.tile[i][j] < 10 ? 10 : 20);
                int n4 = (int)(0.5 * this.rowHgt) + 13;
                graphics.setFont(FONT);
                graphics.setColor(Color.BLUE);
                graphics.drawString("" + this.tile[i][j], n2 + n3, n + n4);
            }
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        this.setEnabled(false);
        int n = (int)(((double)mouseEvent.getY() - 0.03 * (double)this.getHeight()) / this.rowHgt);
        int n2 = (int)(((double)mouseEvent.getX() - 0.03 * (double)this.getWidth()) / this.colWdt);
        this.number = this.tile[n][n2];
        this.notify();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

