/*
 * Decompiled with CFR 0.152.
 */
package queens;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ChessboardView
extends JPanel
implements MouseListener {
    private static final int UNKNOWN = -1;
    private static final int WIDTH = 500;
    private static final int HEIGHT = 500;
    private final int n;
    private double hmg;
    private double vmg;
    private double w;
    private double h;
    private int[] queens;

    public ChessboardView(int n) {
        this.n = n;
        this.queens = new int[n];
        for (int i = 0; i < n; ++i) {
            this.queens[i] = -1;
        }
        JFrame jFrame = new JFrame("Rompicapo delle N Regine");
        jFrame.setSize(500, 500);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", this);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        this.addMouseListener(this);
    }

    public synchronized void setQueens(String string) {
        for (int i = 0; i < this.n; ++i) {
            this.queens[i] = -1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.charAt(1) > '9' ? this.n - string2.charAt(1) + 65 - 10 : this.n - string2.charAt(1) + 49 - 1;
            int n2 = string2.charAt(0) - 97;
            if (0 > n || n >= this.n || 0 > n2 || n2 >= this.n) continue;
            this.queens[n] = n2;
        }
        this.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.hmg = 0.05 * (double)n;
        this.vmg = 0.05 * (double)n2;
        graphics.setColor(Color.gray);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(new Color(255, 204, 76));
        graphics.fillRect(0, 0, (int)((double)n - this.hmg), (int)this.vmg);
        graphics.fillRect((int)this.hmg, (int)((double)n2 - this.vmg), (int)((double)n - this.hmg), (int)this.vmg);
        graphics.fillRect(0, (int)this.vmg, (int)this.hmg, (int)((double)n2 - this.vmg));
        graphics.fillRect((int)((double)n - this.hmg), 0, (int)this.hmg, (int)((double)n2 - this.vmg));
        this.w = 0.9 * (double)n / (double)this.n;
        this.h = 0.9 * (double)n2 / (double)this.n;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                Color color = (i + j) % 2 == 0 ? new Color(255, 204, 76) : new Color(123, 61, 30);
                graphics.setColor(color);
                int n3 = (int)(this.hmg + (double)j * this.w) + 1;
                int n4 = (int)(this.vmg + (double)i * this.h) + 1;
                graphics.fillRect(n3, n4, (int)this.w, (int)this.h);
                graphics.setColor(Color.black);
                graphics.drawRect(n3, n4, (int)this.w, (int)this.h);
                if (this.queens[i] != j) continue;
                int[] nArray = new int[]{n3 + (int)(0.2 * this.w), n3 + (int)(0.2 * this.w), n3 + (int)(0.35 * this.w), n3 + (int)(0.5 * this.w), n3 + (int)(0.65 * this.w), n3 + (int)(0.8 * this.w), n3 + (int)(0.8 * this.w), n3 + (int)(0.7 * this.w), n3 + (int)(0.3 * this.w)};
                int[] nArray2 = new int[]{n4 + (int)(0.5 * this.w), n4 + (int)(0.2 * this.w), n4 + (int)(0.5 * this.w), n4 + (int)(0.2 * this.w), n4 + (int)(0.5 * this.w), n4 + (int)(0.2 * this.w), n4 + (int)(0.5 * this.w), n4 + (int)(0.8 * this.w), n4 + (int)(0.8 * this.w)};
                graphics.setColor(new Color(0, 0, 51));
                graphics.fillPolygon(nArray, nArray2, 9);
                graphics.setColor(new Color(204, 204, 255));
                graphics.drawPolygon(nArray, nArray2, 9);
            }
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        this.notify();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

