/*
 *  file mailbox.c
 */


#include "mailbox.h"


void newChannel(Channel *Chn)
{
  Assign(&Chn->notFull, BUFFSIZE);
  Assign(&Chn->notEmpty, 0);
  initbuffer(&Chn->Bu);
}


void Send(Channel *Chn, Message Msg)
{
  Suspend(&Chn->notFull);
  putmsg(&Chn->Bu, Msg);
  Awake(&Chn->notEmpty);
}


void Recv(Channel *Chn, Message *Msg)
{
  Suspend(&Chn->notEmpty);
  getmsg(&Chn->Bu, Msg);
  Awake(&Chn->notFull);
}
 
