 /*
 *  file kernel.h
 */

#include   <stdio.h>
#include   <stdlib.h>

typedef enum {once, next} Mode;
typedef unsigned int uint;
typedef union {
  int score;
  struct {
    uint over : 11;
    uint gate : 12;
    uint moan : 9;
  } index;
} Masque;

/*-------------------------------------------------------------------
|                   definizioni per Unix Solaris                    |
-------------------------------------------------------------------*/
#ifdef Solaris
#include   <thread.h>
#include   <synch.h>

typedef    thread_t       process ;
typedef    sema_t         semaphore ;
#endif

/*-------------------------------------------------------------------
|                      definizioni per Linux                        |
-------------------------------------------------------------------*/
#ifdef Linux
#include   <pthread.h>
#include   <semaphore.h>

typedef    pthread_t      process ;
typedef    sem_t          semaphore ;
#endif


#define Procedure(X) void *(*X)(void *)

typedef    long int       integer ;
typedef    unsigned int   value ;


extern void NewThread(Procedure(proc), integer StackSize, process *TID);
extern int JoinThread(process TID, process Target);
extern int Thread(process *TID);
extern int Gettid(Mode fx, process *Pid);
extern int pError(process T);

extern void Assign(semaphore *s, value k);
extern void Suspend(semaphore *s);
extern void Awake(semaphore *s);
extern int Score(semaphore *s);

