/*
 *  file kernel.c
 */

#include "kernel.h"

/*-------------------------------------------------------------------
|                creazione e gestione dei processi                  |
-------------------------------------------------------------------*/

void NewThread(Procedure(proc), integer StackSize, process *TID) {
#ifdef Solaris
  if (thr_create(NULL, StackSize, proc, NULL, THR_NEW_LWP, TID))
    *TID = -1;
#endif
#ifdef Linux
  if (StackSize == 0) {
    if (pthread_create(TID, NULL, proc, NULL))
      *TID = -1; }
  else {
    fprintf(stderr, "thread cannot be created\n") ;
    exit(2) ;}
#endif
};


int JoinThread(process TID, process Target) {
#ifdef Solaris
   return thr_join(TID, &Target, NULL);
#endif
#ifdef Linux
   return pthread_join(TID, NULL);
#endif
};

int Thread(process *TID) {
#ifdef Solaris
  return thr_self();
#endif
#ifdef Linux
  return pthread_self();
#endif
};

int Gettid(Mode fx, process *Pid) {
  Masque mask;
  switch (fx) {
    case once: mask.score = Thread(Pid); break;
    case next: mask.score = *Pid; break; }
  return mask.index.gate;
}

int pError(process T) {
  int Rsx, Pid;
  Rsx = (T == -1);
#ifdef DEBUG
  if (Rsx) printf("Can't create thread\n");
  else
    Pid = Gettid(next, &T);
    printf("Nuovo processo %d\n", Pid);
#endif
  return Rsx;
}

/*-------------------------------------------------------------------
|                        gestione dei semafori                      |
-------------------------------------------------------------------*/

void Assign(semaphore *s, value k) {
  /* initialize the semaphore */

#ifdef Solaris
  sema_init(s, k, USYNC_THREAD, 0) ;
#endif
#ifdef Linux
  sem_init(s, 0, k) ;
#endif
} ;

void Suspend(semaphore *s) {
#ifdef Solaris
  sema_wait( s ) ;
#endif
#ifdef Linux
  sem_wait( s ) ;
#endif
} ;

void Awake(semaphore *s) {
#ifdef Solaris
  sema_post( s ) ;
#endif
#ifdef Linux
  sem_post( s ) ;
#endif
} ;

int Score(semaphore *s) {
  int *sval;
#ifdef Solaris
  sema_getvalue( s, sval ) ;
#endif
#ifdef Linux
  sem_getvalue( s, sval ) ;
#endif
return *sval;
} ;
 
