/*
 *  file dies.c
 */

#include    <math.h>
#include    <stdio.h>
#include    <unistd.h>
#include    "mailbox.h"

#define     FALSE       0
#define     TRUE        1

void *Server();
void *Client();

Channel Port;
Channel Reply;


main() {
  process T0, T1, T2;
  int pid;

#ifdef DEBUG
  pid = Gettid(once, &T0);
  printf("Main thread = %d\n", pid);
#endif

  newChannel( &Port );          /* attivazione della porta */
  newChannel( &Reply );         /* canale di risposta */


      /* crea due processi "leggeri" */


  NewThread( Server, 0, &T1 );
  if (pError(T1)) exit(1);

  NewThread( Client, 0, &T2 );
  if (pError(T2)) exit(1);

      /* ricongiungi i due flussi */

  if (JoinThread(T1, T2))
    printf("Joining thread error\n"), exit(2);
#ifdef DEBUG
  pid = Gettid(next, &T1);
  printf("Thread %d terminated.\n", pid);
  pid = Gettid(next, &T2);
  printf("Thread %d terminated.\n", pid);
#endif

      /* termina */

  exit(0);
}


void *Server() {
  int running;
  Message Request;
  Message Answer;
  char CH;
  int N;
  unsigned seed;
  int i, R, Rx;
  int W;

  int toss(int K) {
    int N;
    N = rand();
    while (N > K) {
      N = N / K;}
    return N; }

  seed = time(NULL);
  srand(seed);

  running = TRUE;
  while (running) {
     Recv(&Port, &Request);
     CH = Request.cmd;
     N = Request.xval;
#ifdef DEBUG
     printf("*** Server[CH = %c <===> N = %d] ***\n", CH, N);
#endif
     switch (CH) {
       case 'q' :
         running = FALSE;
         Answer.cmd = 'z';
         break;
       case 'p' :
         Rx = 0;
         for (i = 0; i < N; i++) {
           W = toss(6);
#ifdef DEBUG
           printf("*** Server[W = %d] ***\n", W);
#endif
           Rx = W + Rx; }
         Answer.cmd = 'r';
         Answer.xval = Rx;
         break; }
     Send(&Reply, Answer); }
  }

void *Client() {
  int running, keeping;
  Message To;
  Message From;
  char CH;
  int K, Y;

  printf("Gioco dei Dadi\n");
  printf("  Usage: q | p <int>\n\n");

  running = TRUE;
  keeping = TRUE;
  while (running) {
     if (keeping) printf("> ");
     scanf("%c", &CH);
     switch (CH) {
       case 'q':
         running = FALSE;
         keeping = TRUE;
         To.cmd = CH;
         To.xval = -1;
         break;
       case 'p':
         keeping = TRUE;
         scanf("%d", &K);
         To.cmd = CH;
         To.xval = K;
         break;
       case '\n':
         keeping = FALSE;
         break; }
     if (keeping) {
#ifdef DEBUG
         printf("*** Client[K = %d] ***\n", K);
#endif
         Send(&Port, To);
         Recv(&Reply, &From);

         if (running) {
           CH = From.cmd;
           Y = From.xval;
           if (CH == 'r') {
             printf("\n risultato della giocata : %d\n\n", Y);} }
     } } }

