
package puzzle;


import chessboard.*;

import java.awt.*;


class AugmentedPiece  extends Piece  implements UserItem {


  private final Piece piece;
  private final Image icon;
  
  
  AugmentedPiece( Piece piece, Image icon ) {
  
    this.piece = piece;
    this.icon = icon;
  }
  
  
  // Specializzazione
  
  public boolean attacks( int i, int j, int u, int v ) {
  
    return piece.attacks(i,j,u,v);
  }
  
  
  // Overriding (specializzazione)
  
  public String toString() {
  
    return piece.toString();
  }
  
  
  public UserItem getAnotherSuchItem() {
  
    return new AugmentedPiece( piece, icon );
  }
  
  
  public Image getIcon() {
  
    return icon;
  }

}  // class AugmentedPiece


/*
 * Al di fuori del package "puzzle", le istanze di AugmentedPiece
 * sono viste come oggetti di tipo Piece (classe astratta) oppure
 * di tipo UserItem (interfaccia)
 */


public interface UserItem {


  public UserItem getAnotherSuchItem();
  
  public Image getIcon();


}  // interface UserItem

