
package puzzle;


import chessboard.*;

import java.awt.*;


public class ChessboardControl  {


  private final Board board;
  private final AugmentedPiece[] model;
  
  private AugmentedPiece current = null;
  
  
  public ChessboardControl( int n, Piece[] sample, Image[] icon ) {
  
    Board board = null;
    try {
      board = new Board( n );
    
    } catch ( ChessboardException ce ) {
      ce.printStackTrace();
      System.exit( 0 );
    }
    this.board = board;
    
    int k = sample.length;
    model = new AugmentedPiece[ k ];
    
    for ( int i=0; i<k; i++ ) {
    
      model[i] = new AugmentedPiece( sample[i], icon[i] );
    }
  }
  
  
  public int numberOfItems() {
  
    return model.length;
  }
  
  
  public UserItem getItem( int k ) {
  
    return model[k];
  }
  
  
  public void setCurrent( UserItem item ) {
  
    current = (AugmentedPiece) item;
  }
  
  
  public UserItem newItemAt( int i, int j ) {
  
    if ( current != null ) {
    
      AugmentedPiece item = (AugmentedPiece) current.getAnotherSuchItem();
      try {
        item.placeOn( board, i, j );
      
      } catch ( ChessboardException ce ) {
        ce.printStackTrace();
        System.exit( 0 );
      }
      return item;
    
    } else {
    
      return null;
    }
  }
  
  
  public void getRidOf( UserItem item ) {
  
    try {
      ( (Piece) item ).removeFromBoard();
    
    } catch ( ChessboardException ce ) {
      ce.printStackTrace();
      System.exit( 0 );
    }
  }
  
  
  public boolean safe( UserItem item ) {
  
    try {
      return board.admissiblePlacementFor( (Piece) item );
    
    } catch ( ChessboardException ce ) {
      ce.printStackTrace();
      System.exit( 0 );
      return false;
    }
  }

}  // class ChessboardControl

