
package gui;


import puzzle.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class PieceToolBar  extends JToolBar {


  private static final int ICN_SIZE = 40;
  
  
  private class ToolBarItem  extends JButton  implements ActionListener {
  
    private final UserItem item;
    
    ToolBarItem( UserItem item ) {
    
      super( new ImageIcon(
                   ( item.getIcon() ).getScaledInstance(ICN_SIZE,ICN_SIZE,Image.SCALE_SMOOTH)
                   ) );
      this.item = item;
      addActionListener( this );
    }
    
    public void actionPerformed( ActionEvent ae ) {
    
      control.setCurrent( item );
      
      for ( int k=0; k<tbItem.length; k++ ) {
        tbItem[k].setSelected( false );
      }
      setSelected( true );
    }
  
  }  // inner class ToolBarItem


  private final ToolBarItem[] tbItem;
  private final ChessboardControl control;
  
  
  public PieceToolBar( ChessboardControl control ) {
  
    super( JToolBar.VERTICAL );
    
    this.control = control;
    
    int n = control.numberOfItems();
    tbItem = new ToolBarItem[ n ];
    
    for ( int k=0; k<n; k++ ) {
    
      tbItem[k] = new ToolBarItem( control.getItem(k) );
      add( tbItem[k] );
    }
  }

}  // class PieceToolBar

