
package gui;


import puzzle.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


class Square  extends Canvas  implements MouseListener {


  private final ChessboardControl control;
  private final Color bg;
  
  private int i, j;
  private UserItem item = null;
  
  
  Square( int i, int j, ChessboardControl control ) {
  
    this.i = i;
    this.j = j;
    this.control = control;
    
    bg = ( (i+j)%2 == 0 ) ? Color.ORANGE : Color.WHITE;
    addMouseListener( this );
  }
  
  
  public void paint( Graphics g ) {
  
    int w = getWidth();
    int h = getHeight();
    
    g.setColor( bg );
    g.fillRect( 0, 0, w, h );
    
    if ( item != null ) {
      g.drawImage( item.getIcon(), w/8, h/8, 3*w/4, 3*h/4, this );
      
      if ( !control.safe(item) ) {
        g.setColor( Color.RED );
        g.drawOval( w/10, h/10, 4*w/5, 4*h/5 );
    }}
  }
  
  
  public void mouseClicked( MouseEvent me ) {
  
    if ( item == null ) {
      item = control.newItemAt( i, j );
    } else {
      control.getRidOf(item);
      item = null;
    }
    ( getParent() ).repaint();
  }
  
  public void mousePressed( MouseEvent me )  {}
  public void mouseReleased( MouseEvent me ) {}
  public void mouseEntered( MouseEvent me )  {}
  public void mouseExited( MouseEvent me )   {}


}  // class Square


public class ChessboardView  extends JPanel {


  public ChessboardView( int n, ChessboardControl control ) {
  
    setLayout( new GridLayout(n,n) );
    
    for ( int i=0; i<n; i++ ) {
      for ( int j=0; j<n; j++ ) {
      
        add( new Square(i,j,control) );
    }}
  }
  
  
  public void repaint() {  // Overriding
  
    for ( Component cmp: getComponents() ) {
    
      cmp.repaint();
    }
  }

}  // class ChessboardView

