
package gui;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class ApplicationPane  extends JPanel  implements ComponentListener {


  private final Component view;
  
  
  public ApplicationPane( Component view ) {
  
    this.view = view;
    
    setLayout( null );
    add( view );
    addComponentListener( this );
    arrange();
  }
  
  
  public void componentResized( ComponentEvent ce ) {
  
    arrange();
  }
  
  public void componentMoved( ComponentEvent ce )  {}
  public void componentHidden( ComponentEvent ce ) {}
  public void componentShown( ComponentEvent ce )  {}
  
  
  private void arrange() {
  
    int w = getWidth();
    int h = getHeight();
    
    int q = Math.min( w, h );
    int x = Math.max( 0, (w-h)/2 );
    int y = Math.max( 0, (h-w)/2 );
    
    view.setBounds( x, y, q, q );
    validate();
  }

}  // class ApplicationPane

