
import chessboard.*;
import puzzle.*;
import gui.*;

import java.awt.*;
import javax.swing.*;


public class ApplicationStarter  extends JApplet {


  private static final String IMG_PATH = "images/";
  private static final String[] ICN = new String[] { IMG_PATH + "queen.gif",
                                                     IMG_PATH + "knight.gif",
                                                     IMG_PATH + "bishop.gif",
                                                     IMG_PATH + "rook.gif"    };
  
  private static final Piece[] SAMPLE = new Piece[] { new Queen(),
                                                      new Knight(),
                                                      new Bishop(),
                                                      new Rook()    };
  
  
  public void init() {
  
    Container pane = getContentPane();
    
    int n = ICN.length;
    Image[] icon = new Image[ n ];
    for ( int k=0; k<n; k++ ) {
      icon[k] = getImage( getDocumentBase(), ICN[k] );
    }
    String size = getParameter( "Size" );
    
    setUp( size, pane, icon );
  }
  
  
  private static void setUp( String size, Container pane, Image[] icon ) {
  
    int n = 8;
    try {
      n = Integer.parseInt( size );
      if ( n <= 0 ) {
        n = 8;
      }
    } catch ( Exception e ) {}
    
    for ( int k=0; k<icon.length; k++ ) {
      pane.prepareImage( icon[k], pane );
    }
    ChessboardControl control = new ChessboardControl( n, SAMPLE, icon );
    
    ChessboardView view = new ChessboardView( n, control );
    
    pane.setLayout( new BorderLayout() );
    pane.add( BorderLayout.CENTER, new ApplicationPane(view) );
    
    pane.add( BorderLayout.WEST, new PieceToolBar(control) );
  }
  
  
  public static void main( String[] args ) {
  
    JFrame frame = new JFrame( "Chessboard Puzzles" );
    frame.setSize( 500, 300 );
    
    Container pane = frame.getContentPane();
    
    int n = ICN.length;
    Image[] icon = new Image[ n ];
    for ( int k=0; k<n; k++ ) {
      icon[k] = ( Toolkit.getDefaultToolkit() ).getImage( ICN[k] );
    }
    String size = args[0];
    
    setUp( size, pane, icon );
    
    frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
    frame.setVisible( true );
  }

}  // class ApplicationStarter

