
/*
 * Istruzioni del modello di calcolo Unlimited Register Machine
 * (N. Cutland, "Computability", Cambridge University Press)
 *
 * Istruzione T: trasferimento fra registri.
 */


public class T  extends Instruction {


  private final int m, n;     // Indici registri
  
  
  public T( int m, int n ) {  // m, n > 0
  
    this.m = m;  // Sorgente
    this.n = n;  // Destinazione
  }
  
  
  public void exec( URM machine ) {
  
    machine.tran( m, n );
  }
  
  
  public int upperRegisterIndex() {
  
    if ( m < n ) {
      return n;
    } else {
      return m;
    }
  }

}  // class T
