
/*
 * Istruzioni del modello di calcolo Unlimited Register Machine
 * (N. Cutland, "Computability", Cambridge University Press)
 *
 * Istruzione S: incremento del contenuto di un registro.
 */


public class S  extends Instruction {


  private final int n;  // Indice registro
  
  
  public S( int n ) {   // n > 0
  
    this.n = n;
  }
  
  
  public void exec( URM machine ) {
  
    machine.succ( n );
  }
  
  
  public int upperRegisterIndex() {
  
    return n;
  }

}  // class S
