
/*
 * Programmi del modello di calcolo Unlimited Register Machine
 * (N. Cutland, "Computability", Cambridge University Press)
 *
 * Tipica sequenza di definizione:
 *
 *   P = new Program();
 *   P.add(I1);
 *     ...
 *   P.add(Is);
 *
 * dove  I1, ..., Is  e' la sequenza ordinata di istruzioni.
 */


import java.util.Vector;  // Classe predefinita (API di Java)


public class Program {


  // Vettore di istruzioni
  
  private Vector instructions;                    // Componenti di tipo Instruction
  // private Vector<Instruction> instructions;    // Java5
  
  private int size = 0;
  private int upperIndex = 0;                     // Registri riferiti
  
  
  public Program() {
  
    instructions = new Vector();
    // instructions = new Vector<Instruction>();  // Java5
    
    instructions.addElement( null );              // Componente 0 non utilizzata
  }
  
  
  // Informazioni sul programma
  
  public int size() {
  
    return size;
  }
  
  public int upperRegisterIndex() {
  
    return upperIndex;
  }
  
  
  // Prelievo di un'istruzione
  
  public Instruction fetch( int k ) {             // 1 <= k <= size
  
    if ( (k >= 1) && (k <= size) ) {
      return ( (Instruction) instructions.elementAt(k) );
      // return ( instructions.elementAt(k) );    // Java5
    } else {
      return null;
    }
  }
  
  
  // Introduzione di una nuova istruzione
  
  public void add( Instruction I ) {
  
    instructions.addElement(I);
    size = size + 1;
    if ( I.upperRegisterIndex() > upperIndex ) {
      upperIndex = I.upperRegisterIndex();
    }
  }

}  // class Program
