
/*
 * Istruzioni del modello di calcolo Unlimited Register Machine
 * (N. Cutland, "Computability", Cambridge University Press)
 *
 * Istruzione J: salto condizionato.
 */


public class J  extends Instruction {


  private final int m, n, q;         // indici registri e istruzione
  
  
  public J( int m, int n, int q ) {  // m, n, q > 0
  
    this.m = m;  // Registri implicati
    this.n = n;  // dalla condizione
    
    this.q = q;  // Riferimento istruzione
  }
  
  
  public void exec( URM machine ) {
  
    machine.jump( m, n, q );
  }
  
  
  public int upperRegisterIndex() {
  
    if ( m < n ) {
      return n;
    } else {
      return m;
    }
  }

}  // class J
