
Require Import List.

(* Syntax of F< types *)

Parameter Var: Set.

Definition Lab := nat.

Inductive Tp: Set := top: Tp
                  |  var: Var -> Tp
                  |  arr: Tp -> Tp -> Tp
                  |  fa : Tp -> (Var -> Tp) -> Tp
                  |  rcd: list (Lab * Tp) -> Tp.

Coercion var: Var >-> Tp.

(* Occur checking predicates *)

Inductive isin (x:Var): Tp -> Prop :=
          isin_var: isin x x
        | isin_arr: forall S T:Tp, 
                    isin x S \/ isin x T ->
                    isin x (arr S T)
        | isin_fa : forall S:Tp, forall T:Var->Tp,
                    isin x S \/ (forall y:Var, ~x=y -> isin x (T y)) ->
                    isin x (fa S T)
        | isin_rcd: forall L:list (Lab*Tp),
                    isin_lTp x L ->
                    isin x (rcd L)
with isin_lTp (x:Var): list (Lab*Tp) -> Prop :=
          isin_2nd: forall p:Lab*Tp, forall L:list (Lab*Tp),
                    isin x (snd p) \/ isin_lTp x L ->
                    isin_lTp x (p :: L).

Inductive notin (x:Var): Tp -> Prop :=
          notin_top: notin x top
        | notin_var: forall y:Var, 
                     ~x=y ->
                     notin x y
        | notin_arr: forall s t:Tp, 
                     notin x s -> notin x t ->
                     notin x (arr s t)
        | notin_fa : forall s:Tp, forall t:Var->Tp,
                     (notin x s) -> 
                     (forall y:Var, ~x=y -> notin x (t y)) ->
                     notin x (fa s t)
        | notin_rcd: forall L:list (Lab*Tp),
                     notin_lTp x L ->
                     notin x (rcd L)
with notin_lTp (x:Var): list (Lab*Tp) -> Prop :=
        | notin_nil: notin_lTp x nil
        | notin_2nd: forall p:Lab*Tp, forall L:list (Lab*Tp),
                     notin x (snd p) /\ notin_lTp x L ->
                     notin_lTp x (p :: L).

Definition notin_ho:= fun x: Var => fun s: Var -> Tp => 
                      forall y: Var, x<>y -> (notin x (s y)).

Definition notin_lTp_ho:= fun x: Var => fun L: Var->list(Lab*Tp) => 
                          forall y: Var, x<>y -> (notin_lTp x (L y)).