
Lemma eq_lab_dec: forall m n:Lab,
                  m=n \/ ~m=n.
double induction m n.
tauto.
intros. auto.
intros. auto.
intros. 
assert (n1=n \/ n1<>n). apply (H0 n).
inversion_clear H1.
rewrite H2. auto.
auto.
Qed.

Lemma incl_element: forall s t u: list Lab, forall m,
      incl (app s (m :: t)) u -> incl (app s t) u.
induction s.

simpl. unfold incl. intros.
apply H. simpl. tauto.

intros. unfold incl. intros.
unfold incl in H. inversion_clear H0.
rewrite <- H1. apply H. simpl. tauto.
apply H. simpl. right.
unfold incl in IHs. apply IHs with t m.
intros. assumption. assumption.
Qed.

Lemma incl_forward: forall t: list Lab, forall m n: Lab,
      incl (m :: nil) (n :: t) -> m <> n ->
      incl (m :: nil) t.
unfold incl. simpl. intros.

assert (n = a \/ In a t). apply H. assumption.
inversion_clear H2.
inversion_clear H1.
absurd (a <> a). auto. rewrite H3 in H0. rewrite H2 in H0. assumption.
contradiction.
assumption.
Qed.

Lemma pair2fst: forall l T P, In (l,T) P ->
                              In l (proj_lab P).
induction P; intros.

simpl in H. contradiction.

destruct a. inversion_clear H.
rewrite H0. simpl. tauto.
simpl. right. apply IHP. assumption.
Qed. 

Lemma same_pair: forall l p q,
                 In p l /\ In q l /\ fst p = fst q -> NoDup (proj_lab l) ->
                 p = q.
induction l; intros.

simpl in H. inversion_clear H. contradiction.

inversion_clear H. inversion_clear H2.

simpl in H1. inversion_clear H1.
simpl in H. inversion_clear H.

rewrite <- H2. assumption.

rewrite H2 in H0. clear H2 a.
destruct p. destruct q.
simpl in H0. inversion_clear H0. clear H2.
simpl in H3. rewrite H3 in H. clear H3.
contradict H. apply pair2fst with t0. assumption. 

simpl in H. inversion_clear H.
rewrite H1 in H0. clear H1 a.
destruct p. destruct q.
simpl in H0. inversion_clear H0. clear H1.
simpl in H3. rewrite H3 in H2. clear H3.
contradict H. apply pair2fst with t. assumption.

apply IHl.
tauto.
destruct a. simpl in H0. inversion_clear H0. assumption.
Qed.

Lemma Gclosed_up_rcd:
      forall S G,
      (forall p, In p S -> Gclosed (snd p) G) -> 
      Gclosed (rcd S) G.
induction S.

(* S = nil *)

intros. unfold Gclosed.
intros. inversion_clear H0. inversion H1.

(* S = a::S *)

intros. unfold Gclosed.
intros. inversion_clear H0.
inversion_clear H1. inversion_clear H0.

apply H with a.
simpl. tauto. assumption.

unfold Gclosed in IHS at 2. apply IHS.
intros. apply H. apply in_cons. assumption.
apply isin_rcd. assumption.
Qed.

Lemma projections:
      forall Q P: list (Lab*Tp), forall p,
      incl (proj_lab (p :: Q)) (proj_lab P) ->
      exists T, In (fst p, T) P.
induction Q.

induction P.

intros. destruct p.
unfold incl in H. simpl in H.
contradict H. unfold not. intros.
apply (H l). tauto.

intros. destruct a. destruct p.
elim (eq_lab_dec l0 l); intros.

rewrite H0. exists t. simpl. tauto.

simpl. assert (exists T : Tp, In (l0, T) P).
replace l0 with (fst (l0, t0)).
apply IHP. simpl in H. simpl.
apply incl_forward with l. assumption. assumption.

unfold fst. reflexivity.
elim H1; clear H1. intro S; intros.
exists S. tauto.

intros. apply IHQ.
destruct a. destruct p.
simpl. simpl in H. 

change (incl (app (l0 :: nil) (proj_lab Q)) (app nil (proj_lab P))).
apply incl_element with l. simpl. assumption.
Qed.

Lemma projections2:
      forall Q P: list (Lab*Tp), forall q,
      incl (proj_lab Q) (proj_lab P) -> In q Q ->
      exists T, In (fst q, T) P.
induction Q.
intros. simpl in H0. contradiction.

induction P.

intros. destruct a.
unfold incl in H. simpl in H.
contradict H. unfold not. intros.
apply (H l). tauto.

clear IHP. 
intros. destruct a. destruct a0.

inversion_clear H0.

apply projections with Q.
rewrite <- H1. assumption.

apply IHQ.
change (incl (app nil (proj_lab Q)) (proj_lab ((l0, t0) :: P))).
apply incl_element with l. simpl. simpl in H. assumption.
assumption.

Qed.

Lemma force_lab: forall R P Q p r,
      incl (proj_lab R) (proj_lab Q) ->
      incl (proj_lab Q) (proj_lab P) ->
      In p P /\ In r R /\ fst p = fst r ->
      exists q, In q Q /\ fst q = fst p.
induction R; intros.
simpl in H1. tauto.
destruct a. destruct r.
inversion_clear H1. inversion_clear H3. simpl in H1.
inversion_clear H1.

rewrite H3 in H; clear H3.
assert (exists T, In (fst (l0, t0), T) Q).
apply projections with R. assumption.
elim H1; clear H1. intro T; intros.
exists (l0, T). auto.

apply IHR with P (l0, t0).
apply incl_tran with (proj_lab ((l, t) :: R)).
simpl. apply incl_tl. apply incl_refl. assumption. 
assumption.
tauto.
Qed.

Lemma Gclosed_record:
      forall Q P G,
      incl (proj_lab Q) (proj_lab P) ->
      (forall p q: Lab*Tp, In p P /\ In q Q /\ fst p = fst q ->
                           Gclosed (snd q) G) ->
      Gclosed (rcd Q) G.

destruct Q; intros.

(*** Q = nil ***)

unfold Gclosed. intros.
inversion H1. inversion H3.

(*** Q = p::Q ***)

apply Gclosed_up_rcd. intro q; intros.
inversion_clear H1.

(* q = p *)

rewrite <- H2. clear H2 q. 

assert (exists T, In (fst p, T) P).
apply projections with Q. assumption.
elim H1. clear H1. intro T; intros. 

apply H0 with (p0 := (fst p, T)).
split. assumption.
split. simpl. tauto.
simpl. reflexivity.

(* q in Q *)

assert (exists T, In (fst q, T) P).
apply projections2 with Q.
change (incl (app nil (proj_lab Q)) (proj_lab P)).
destruct p. apply incl_element with l. 
simpl. simpl in H. assumption.
assumption.

elim H1. clear H1. intro T; intros.

apply H0 with (p0 := (fst q, T)).
split. assumption. 
split. simpl. tauto. 
simpl. reflexivity.
Qed.