
(* Typing Environment and its Well-fordmedness - deep version *)

Definition envTp: Set := (list (Var * Tp)).

Inductive Gfresh (x:Var): envTp -> Prop :=
          GfVoid: Gfresh x nil
        | GfGrow: forall G:envTp, forall y:Var, forall T:Tp,
                  Gfresh x G -> ~x=y ->
                  Gfresh x (cons (y,T) G).

Inductive isinG (x:Var) (T:Tp): envTp -> Prop :=
          checkG: forall G:envTp, forall y:Var, forall U:Tp,
                  (x=y /\ T=U) \/ isinG x T G ->
                  isinG x T (cons (y,U) G).

Definition Gclosed (T:Tp) (G:envTp): Prop :=
           forall x:Var,
           (isin x T) -> exists U:Tp, isinG x U G.


Inductive okEnv: envTp -> Prop :=
          okVoid: okEnv nil
        | okGrow: forall G:envTp, forall x:Var, forall T:Tp,
                  okEnv G ->
                  Gfresh x G -> Gclosed T G ->
                  okEnv (cons (x,T) G).

(* Subtyping predicate - deep version *)   

Fixpoint proj_lab (P: list (Lab*Tp)) : (list Lab) :=
         match P with | nil => nil
                      | (l,T) :: Q => (cons l (proj_lab Q))
         end.

Inductive subTp: envTp -> Tp -> Tp -> Prop :=

          sub_top: forall G: envTp, forall S: Tp,
                   okEnv G -> Gclosed S G ->
                   subTp G S top

        | sub_var: forall G: envTp, forall x: Var, forall U: Tp,
                   okEnv G -> isinG x U G ->
                   subTp G x x

        | sub_trs: forall G: envTp, forall x: Var, forall U T: Tp,
                   isinG x U G -> subTp G U T ->
                   subTp G x T

        | sub_arr: forall G: envTp, forall S1 S2 T1 T2: Tp,
                   subTp G T1 S1 -> subTp G S2 T2 ->
                   subTp G (arr S1 S2) (arr T1 T2)

        | sub_fa : forall G: envTp,
                   forall S1 T1: Tp, forall S2 T2: Var->Tp,
                   subTp G T1 S1 ->
                   (forall x:Var, okEnv (cons (x,T1) G) ->
                                  subTp (cons (x,T1) G) (S2 x) (T2 x)) ->
                   subTp G (fa S1 S2) (fa T1 T2)

        | sub_rcd: forall G: envTp,
                   forall P Q: list (Lab*Tp),
                   okEnv G -> Gclosed (rcd P) G ->
                   NoDup (proj_lab P) ->
                   incl (proj_lab Q) (proj_lab P) ->
                   (forall p q:Lab*Tp, In p P /\ In q Q /\ (fst p = fst q) ->
                                       subTp G (snd p) (snd q)) -> 
                   subTp G (rcd P) (rcd Q).