
(* Main proofs: reflexivity and transitivity-narrowing *)

Inductive wf: Tp -> Prop :=
          wf_top: wf top
        | wf_var: forall x: Var, wf x
        | wf_arr: forall S T: Tp,
                  wf S -> wf T ->
                  wf (arr S T)
        | wf_fa : forall S: Tp, forall T: Var->Tp, 
                  wf S -> (forall x:Var, wf (T x)) ->
                  wf (fa S T)
        | wf_rcd: forall P: list (Lab*Tp),
                  NoDup (proj_lab P) ->
                  (forall p, In p P -> wf (snd p)) ->
                  wf (rcd P).

Lemma reflexivity: forall T: Tp, forall G: envTp,
      okEnv G -> Gclosed T G -> wf T -> subTp G T T.

induction T using Tp_rec_ext; intros.

 apply sub_top.
  assumption.
 assumption.

unfold Gclosed in H0.
  cut (exists U : Tp, isinG v U G); [ intro | apply H0; apply isin_var ].
  inversion_clear H2.
  apply sub_var with x; auto.

apply sub_arr.
 apply IHT1; auto.
   unfold Gclosed in |- *; unfold Gclosed in H0; intros.
   apply H0.
   apply isin_arr; left; assumption.
   inversion_clear H1. assumption.
 apply IHT2; auto.
   unfold Gclosed in |- *; unfold Gclosed in H0; intros; apply H0;
   apply isin_arr; right; assumption.
   inversion_clear H1. assumption.

apply sub_fa; intros.
 apply IHT; auto.
   unfold Gclosed in |- *; unfold Gclosed in H1; intros; apply H1.
   apply isin_fa; left; assumption.
   inversion_clear H2. assumption.
apply H; auto.
  unfold Gclosed in |- *; intros.
  unfold Gclosed in H1.
  inversion H3.
  elim (LEM_Var x x0); intros.
 rewrite <- H11 in |- *; exists T.
   apply checkG; left; auto.
cut (exists U : Tp, isinG x0 U G); [ intro | apply H1; auto ].
 inversion H12.
   exists x2; apply checkG; right; assumption.
apply isin_fa; right; intros.

apply isin_mono with x; auto.
inversion H2. apply H7.

(* records *)

apply sub_rcd.
assumption. assumption.
inversion_clear H2. assumption.
apply incl_refl.

intros. inversion_clear H2.
assert (p = q). apply same_pair with L. assumption. assumption.
rewrite H2. rewrite H2 in H3.
inversion_clear H3. clear H7 H2 p.

induction L.

simpl in H6. contradiction.

destruct a. destruct q.
simpl in H6. inversion_clear H6.

rewrite <- H2. simpl. simpl in H. apply H. 
assumption. 
unfold Gclosed in H1. simpl in H1. unfold Gclosed. intros.
apply H1. apply isin_rcd. apply isin_2nd. tauto.
replace t with (snd (l,t)). apply H5. simpl. tauto. auto.

apply IHL. 
simpl in H. inversion_clear H. assumption.
unfold Gclosed in H1. simpl in H1. unfold Gclosed. intros.
apply H1. apply isin_rcd. inversion_clear H3. apply isin_2nd. tauto.
inversion_clear H4. assumption.
intros. apply H5. apply in_cons. assumption.
assumption.
Qed.

Lemma trans_var: forall G: envTp, forall x:Var, forall S Q: Tp, 
      Q=x -> subTp G S Q -> 
      forall T: Tp, subTp G Q T -> subTp G S T.
induction 2; intros.
inversion H.
assumption.
apply sub_trs with U; auto.
inversion_clear H.
inversion_clear H.

inversion_clear H.
Qed.

Lemma trans_arr: forall G: envTp, forall Q1 Q2 S: Tp, 
      (forall (S : Tp) (G : envTp),
       subTp G S Q1 -> forall T : Tp, subTp G Q1 T -> subTp G S T) ->
      (forall (S : Tp) (G : envTp),
       subTp G S Q2 -> forall T : Tp, subTp G Q2 T -> subTp G S T) ->
      subTp G S (arr Q1 Q2) ->
      forall T : Tp, subTp G (arr Q1 Q2) T -> subTp G S T.
intros.
cut
 (forall Q S : Tp, forall G: envTp,
  Q = arr Q1 Q2 -> subTp G S Q -> forall T : Tp, subTp G Q T -> subTp G S T);
 [ intros; apply H3 with (arr Q1 Q2); auto | idtac ].
  induction 2; intros.
 inversion_clear H3.
assumption.
rewrite H3 in H5; rewrite H3 in H6.
 inversion H6.
 apply sub_top; auto.
   unfold Gclosed in |- *; intros.
   inversion H12.
   exists U; assumption.
apply sub_trs with U; auto.
  apply IHsubTp; auto.
  rewrite H3 in |- *.
  apply sub_arr; auto.
  inversion H4.
 apply sub_top; auto.
   cut (Gclosed T1 G0 /\ Gclosed S1 G0); [ intro | apply Gclosed_lemma; auto ].
   cut (Gclosed S2 G0 /\ Gclosed T2 G0); [ intro | apply Gclosed_lemma; auto ].
   inversion_clear H10; inversion_clear H11; unfold Gclosed in |- *; intros.
   inversion_clear H11.
   inversion_clear H15.
  unfold Gclosed in H13.
    apply H13; auto.
 unfold Gclosed in H10; apply H10; auto.
apply sub_arr.
inversion H3; apply H; auto.
rewrite <- H12; assumption.
rewrite <- H12; assumption.
inversion H3; apply H0; auto.
rewrite <-H13; assumption.
rewrite <-H13; assumption.
inversion_clear H3.

inversion_clear H3.
Qed.

Lemma trans_fa: forall (S : Tp) (G : envTp) (Q : Tp) (t : Var -> Tp),
(forall v : Var,
 forall (S : Tp) (G : envTp),
 subTp G S (t v) -> forall T : Tp, subTp G (t v) T -> subTp G S T) ->

(forall (S : Tp) (G : envTp),
 subTp G S Q -> forall T : Tp, subTp G Q T -> subTp G S T) ->
      
(forall (G' : envTp) (M N : Tp),
 subTp G' M N ->
 forall (D : list (Var * Tp)) (x : Var) (G : list (Var * Tp)) (P : Tp),
 G' = D ++ (x, Q) :: G -> subTp G P Q -> subTp (D ++ (x, P) :: G) M N) ->
subTp G S (fa Q t) -> forall T : Tp, subTp G (fa Q t) T -> subTp G S T.
intros.
cut
 (forall R S : Tp, forall G: envTp,
  R = fa Q t -> subTp G S R -> forall T : Tp, subTp G R T -> subTp G S T);
 [ intros; apply H4 with (fa Q t); auto | idtac ].
induction 2; intros.
 inversion_clear H4.
 inversion_clear H4.
  rewrite H4 in H6; rewrite H4 in H7.
  apply sub_trs with U; auto.
  apply IHsubTp; auto.
  rewrite H4 in |- *; assumption.
inversion_clear H4.

inversion H4.
inversion H8.

 apply sub_top; auto.
   unfold Gclosed in |- *; intros.
   inversion_clear H16.
   inversion_clear H17.
  cut (Gclosed T1 G0 /\ Gclosed S1 G0); [ intro | apply Gclosed_lemma; auto ].
    inversion_clear H17.
    unfold Gclosed in H19; apply H19; auto.
 elim (unsatG ((x, T1) :: G0)); intros.
   cut (subTp ((x0, T1) :: G0) (S2 x0) (T2 x0)); [ intro | apply H6; auto ].
  cut (Gclosed (S2 x0) ((x0, T1) :: G0) /\ Gclosed (T2 x0) ((x0, T1) :: G0));
   [ intro | apply Gclosed_lemma; auto ].
   inversion_clear H19.
     unfold Gclosed in H20.
     cut (exists U : Tp, isinG x U ((x0, T1) :: G0));
      [ intro | apply H20; auto ].
    inversion_clear H19.
      inversion_clear H22.
      inversion_clear H19.
     inversion_clear H17; inversion_clear H22.
        absurd (x = x0).
      auto.
     auto.
    exists x1; assumption.
   inversion_clear H17; apply H16; auto.
  apply okGrow; intros; auto.
   inversion_clear H17; auto.
  cut (Gclosed T1 G0 /\ Gclosed S1 G0); [ intro | apply Gclosed_lemma; auto ].
     tauto.

apply sub_fa; intros.
 apply H0; auto.
    rewrite <- H10 in |- *; assumption.
   rewrite <- H10 in |- *; assumption.
cut (subTp ((x, T1) :: G0) (S2 x) (T2 x)); [intro | apply H6; auto].
cut (subTp (nil ++ (x, T3) :: G0) (S2 x) (T2 x)); [intro | apply H1 with (nil ++ (x, T1) :: G0); auto].
simpl in H19; apply (H x); auto.
rewrite <-H11; assumption.
rewrite <-H11; apply H16; auto.
rewrite <-H10; trivial.
rewrite <-H10; assumption.
apply okGrow; auto.
inversion_clear H17; auto.
inversion_clear H17; auto.
cut (Gclosed T3 G0 /\ Gclosed T1 G0); [intro | apply Gclosed_lemma; auto].
tauto.

inversion_clear H4.
Qed.

(* records *)

Lemma trans_rcd: forall L S G,
      (forall p, In p L ->
       forall S G, subTp G S (snd p) -> forall T : Tp, subTp G (snd p) T ->
       subTp G S T) ->
      subTp G S (rcd L) ->
      forall T: Tp, subTp G (rcd L) T -> subTp G S T.

intros.
cut (forall Q S G,
     Q=(rcd L) -> subTp G S Q -> 
     forall T: Tp, subTp G Q T -> subTp G S T).
intros. apply H2 with (rcd L). reflexivity. assumption. assumption.

induction 2; intros. 

inversion H2. inversion H2.

rewrite H2 in H4, H5.
inversion H5.

apply sub_top. assumption.
unfold Gclosed; intros.
inversion H11. exists U. assumption.

apply sub_trs with U.
assumption.
apply IHsubTp. assumption.
rewrite H2. apply sub_rcd.
assumption. assumption. assumption. assumption. assumption.  

inversion H2. inversion H2.

clear H8. inversion H9.
apply sub_top. assumption. assumption.
apply sub_rcd.
assumption. assumption. assumption.
apply incl_tran with (proj_lab Q). assumption. assumption.
intros. assert (exists r, In r Q /\ fst r = fst p).

apply force_lab with Q0 P q.
assumption. assumption. assumption.

elim H18; clear H18. intro r. intros.
apply H with r. inversion H2. rewrite <- H20. tauto.
apply H7. split. tauto.
inversion_clear H18. split. assumption. auto.
apply H15. split. tauto. split. tauto. 
inversion_clear H18. rewrite H20. tauto.
Qed.

(***************** CHALLENGE 1B **************************)

(* A logical tautology *)

Lemma mpx: forall A B: Prop,
           A -> (A -> B) ->
           A /\ B.
intros. split.
assumption. 
apply H0. assumption.
Qed.

Theorem challenge_1B: forall Q: Tp,

(forall S: Tp, forall G: envTp, subTp G S Q -> 
               forall T: Tp, subTp G Q T -> subTp G S T)
/\
(forall G':envTp, forall M N: Tp, subTp G' M N ->
                  forall D x G P, 
                  G'=(app D (cons (x,Q) G)) ->
                  subTp G P Q ->
                  subTp (app D (cons (x,P) G)) M N).

induction Q using Tp_ind_ext.

(************************* TOP *************************)

split.

(*** Trans: top case ***)

intros.   inversion H0.
   apply sub_top; auto.
   cut (Gclosed S G /\ Gclosed top G); [ intro | apply Gclosed_lemma; auto ].
    tauto.

(*** Narrow: top case ***)

induction 1.

(* top-top *)

intros. rewrite H1 in H, H0; clear H1. clear G.

apply sub_top.

apply subTp_preserves_okEnv with top. assumption. assumption.

apply Gclosed_preserved with top. assumption.

(* top-var *)

intros. rewrite H1 in H, H0; clear H1. clear G.
elim (LEM_Var x x0).

intro. rewrite H1. 
apply sub_var with P.
apply subTp_preserves_okEnv with top. assumption. assumption.
apply isinG_inside.

intro.
apply sub_var with U.
apply subTp_preserves_okEnv with top. assumption. assumption.
apply isinG_somewhere with top. assumption. assumption.

(* top-trs *)

intros. rewrite H1 in IHsubTp, H, H0; clear H1. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H1. rewrite H1 in H, H0, IHsubTp; clear H1 x0.
apply sub_trs with P.

apply isinG_inside.

rewrite (isinG_type x U D top G0) in H0.

inversion_clear H0.
apply sub_top.
apply subTp_preserves_okEnv with top. assumption. assumption.

assert (Gclosed P G0 /\ Gclosed top G0).
apply Gclosed_lemma. assumption.

apply Gclosed_preserved_env. 

apply Gclosed_preserved_pair. tauto.

assumption. 

apply subTp_ensures_okEnv with U T. assumption.

intro. 
apply sub_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 top. assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubTp. reflexivity. assumption.

(* top-arr *)

intros. rewrite H1 in IHsubTp1, IHsubTp2; clear H1. clear G H H0. 

apply sub_arr.
apply IHsubTp1. reflexivity. assumption.
apply IHsubTp2. reflexivity. assumption.

(* top-fa *)

intros. rewrite H2 in H1, IHsubTp, H, H0; clear H2. clear G. 

apply sub_fa.
apply IHsubTp. reflexivity. assumption.
intros. apply H1 with (D0 := (x0,T1)::D).

apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.

(* top-rcd *)

intros. rewrite H5 in H3, H4, H, H0; clear H5. clear G. 
apply sub_rcd.
apply subTp_preserves_okEnv with top. assumption. assumption.
apply Gclosed_preserved with top. assumption.
assumption. assumption.
intros. apply H4. assumption. reflexivity. assumption. 

(************************* VAR *************************)

apply mpx.

(*** Trans: var case ***)

intros. apply trans_var with v v; auto.

(*** Narrow: var case ***)

intro.
induction 1.

(* var-top *)

intros. rewrite H2 in H0, H1; clear H2. clear G.

apply sub_top.
apply subTp_preserves_okEnv with v. assumption. assumption.

apply Gclosed_preserved with v. assumption.

(* var-var *)

intros. rewrite H2 in H0, H1; clear H2. clear G.
elim (LEM_Var x x0).

intro. rewrite H2. 
apply sub_var with P.
apply subTp_preserves_okEnv with v. assumption. assumption.
apply isinG_inside.

intro.
apply sub_var with U.
apply subTp_preserves_okEnv with v. assumption. assumption.
apply isinG_somewhere with v. assumption. assumption.

(* var-trs *)

intros. rewrite H2 in IHsubTp, H0, H1; clear H2. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H2. rewrite H2 in H0, H1, IHsubTp; clear H2 x0.
apply sub_trs with P.

apply isinG_inside.

apply H.
assert (G0 = (app nil G0)). simpl. reflexivity. rewrite H2; clear H2.
assert ((D ++ (x, P) :: nil ++ G0) = (D ++ (x, P) :: nil) ++ G0).
apply eq_sym. apply app_ass. rewrite H2; clear H2.

apply weakening. assumption. 

rewrite app_ass. apply subTp_preserves_okEnv with v.

apply subTp_ensures_okEnv with U T.
assumption. assumption.

assert (U = (var v)). 

rewrite (isinG_type x U D v G0).
reflexivity. assumption. 
apply subTp_ensures_okEnv with U T. assumption.
rewrite H2 in IHsubTp; clear H2.

apply IHsubTp.
reflexivity. assumption. 

intro. 
apply sub_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 v. assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubTp.
reflexivity. assumption.

(* var-arr *)

intros. rewrite H0 in IHsubTp1, IHsubTp2; clear H0. clear G H0_ H0_0. 

apply sub_arr.
apply IHsubTp1. reflexivity. assumption.
apply IHsubTp2. reflexivity. assumption.

(* var-fa *)

intros. rewrite H3 in H2, IHsubTp, H0, H1; clear H3. clear G. 

apply sub_fa.
apply IHsubTp. reflexivity. assumption.
intros.
assert ((forall (D0 : list (Var * Tp)) (x1 : Var) (G : list (Var * Tp)) (P : Tp),
       (x0, T1) :: D ++ (x, (var v)) :: G0 = D0 ++ (x1, (var v)) :: G ->
       subTp G P v -> subTp (D0 ++ (x1, P) :: G) (S2 x0) (T2 x0))).
apply H2.
apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.

apply H2 with (D0 := (x0,T1)::D).
apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.

(* var-rcd *)

intros. rewrite H6 in H4, H5, H0, H1; clear H6. clear G. 
apply sub_rcd.
apply subTp_preserves_okEnv with v. assumption. assumption.
apply Gclosed_preserved with v. assumption.
assumption. assumption.
intros. apply H5. assumption. reflexivity. assumption. 

(************************* ARR *************************)

apply mpx.

(*** Trans: arr case ***)

intros.
apply trans_arr with Q1 Q2. tauto. tauto.
assumption. assumption. 

(*** Narrow: arr case ***)

intro.
induction 1.

(* arr-top *)

clear IHQ1 IHQ2.
intros. rewrite H2 in H0, H1; clear H2. clear G.

apply sub_top.
apply subTp_preserves_okEnv with (arr Q1 Q2). assumption. assumption.

apply Gclosed_preserved with (arr Q1 Q2). assumption.

(* arr-var *)

clear IHQ1 IHQ2. intros.
rewrite H2 in H0, H1; clear H2. clear G.
elim (LEM_Var x x0).

intro. rewrite H2. 
apply sub_var with P.
apply subTp_preserves_okEnv with (arr Q1 Q2). assumption. assumption.
apply isinG_inside.

intro.
apply sub_var with U.
apply subTp_preserves_okEnv with (arr Q1 Q2). assumption. assumption.
apply isinG_somewhere with (arr Q1 Q2). assumption. assumption.

(* arr-trs *)

clear IHQ1 IHQ2.
intros. rewrite H2 in IHsubTp, H0, H1; clear H2. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H2. rewrite H2 in H0, H1, IHsubTp; clear H2 x0.
apply sub_trs with P.

apply isinG_inside.

apply H.

assert (G0 = (app nil G0)). simpl. reflexivity. rewrite H2; clear H2.
assert ((D ++ (x, P) :: nil ++ G0) = (D ++ (x, P) :: nil) ++ G0).
apply eq_sym. apply app_ass. rewrite H2; clear H2.

apply weakening. assumption. 

rewrite app_ass. apply subTp_preserves_okEnv with (arr Q1 Q2).

apply subTp_ensures_okEnv with U T.
assumption. assumption.

assert (U = (arr Q1 Q2)). 

rewrite (isinG_type x U D (arr Q1 Q2) G0).
reflexivity. assumption. 
apply subTp_ensures_okEnv with U T. assumption.
rewrite H2 in IHsubTp; clear H2.

apply IHsubTp.
reflexivity. assumption. 

intro. 
apply sub_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 (arr Q1 Q2). assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubTp. reflexivity. assumption.

(* arr-arr *)

clear IHQ1 IHQ2.
intros. rewrite H0 in IHsubTp1, IHsubTp2; clear H0. clear G H0_ H0_0. 

apply sub_arr.
apply IHsubTp1. reflexivity. assumption.
apply IHsubTp2. reflexivity. assumption.

(* arr-fa *)

clear IHQ1 IHQ2.
intros. rewrite H3 in H2, IHsubTp, H0, H1; clear H3. clear G. 

apply sub_fa.
apply IHsubTp. reflexivity. assumption.
intros.
assert ((forall (D0 : list (Var * Tp)) (x1 : Var) (G : list (Var * Tp)) (P : Tp),
       (x0, T1) :: D ++ (x, (arr Q1 Q2)) :: G0 = D0 ++ (x1, (arr Q1 Q2)) :: G ->
       subTp G P (arr Q1 Q2) -> subTp (D0 ++ (x1, P) :: G) (S2 x0) (T2 x0))).
apply H2.
apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.

apply H2 with (D0 := (x0,T1)::D).
apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.

(* arr-rcd *)

intros. rewrite H6 in H4, H5, H0, H1; clear H6. clear G. 
apply sub_rcd.
apply subTp_preserves_okEnv with (arr Q1 Q2). assumption. assumption.
apply Gclosed_preserved with (arr Q1 Q2). assumption.
assumption. assumption.
intros. apply H5. assumption. reflexivity. assumption. 

(************************* FA *************************)

apply mpx.

(*** Trans: fa case ***)

do 2 intro. apply trans_fa.
intro. elim (H v). tauto. 
apply IHQ. apply IHQ.

(*** Narrow: fa case ***)

intro.
induction 1.

(* fa-top *)

clear IHQ H.
intros. rewrite H in H1, H2; clear H. clear G.

apply sub_top.
apply subTp_preserves_okEnv with (fa Q t). assumption. assumption.

apply Gclosed_preserved with (fa Q t). assumption.

(* fa-var *)

clear IHQ H.
intros. rewrite H in H1, H2; clear H. clear G.
elim (LEM_Var x x0).

intro. rewrite H. 
apply sub_var with P.
apply subTp_preserves_okEnv with (fa Q t). assumption. assumption.
apply isinG_inside.

intro.
apply sub_var with U.
apply subTp_preserves_okEnv with (fa Q t). assumption. assumption.
apply isinG_somewhere with (fa Q t). assumption. assumption.

(* fa-trs *)

clear IHQ H.
intros. rewrite H in IHsubTp, H1, H2; clear H. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H. rewrite H in H1, H2, IHsubTp; clear H x0.
apply sub_trs with P.

apply isinG_inside.

apply H0.

assert (G0 = (app nil G0)). simpl. reflexivity. rewrite H; clear H.
assert ((D ++ (x, P) :: nil ++ G0) = (D ++ (x, P) :: nil) ++ G0).
apply eq_sym. apply app_ass. rewrite H; clear H.

apply weakening. assumption. 

rewrite app_ass. apply subTp_preserves_okEnv with (fa Q t).

apply subTp_ensures_okEnv with U T.
assumption. assumption.

assert (U = (fa Q t)). 

rewrite (isinG_type x U D (fa Q t) G0).
reflexivity. assumption. 
apply subTp_ensures_okEnv with U T. assumption.
rewrite H in IHsubTp; clear H.

apply IHsubTp.  
reflexivity. assumption. 

intro. 
apply sub_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 (fa Q t). assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubTp. reflexivity. assumption.

(* fa-arr *)

clear H IHQ.
intros. rewrite H in IHsubTp1, IHsubTp2; clear H. clear G H1_ H1_0. 

apply sub_arr.
apply IHsubTp1. reflexivity. assumption.
apply IHsubTp2. reflexivity. assumption.

(* fa-fa *)

clear H IHQ.
intros. rewrite H in H2, IHsubTp, H1, H3; clear H. clear G. 

apply sub_fa.
apply IHsubTp. reflexivity. assumption.
intros.
assert ((forall (D0 : list (Var * Tp)) (x1 : Var) (G : list (Var * Tp)) (P : Tp),
       (x0, T1) :: D ++ (x, (fa Q t)) :: G0 = D0 ++ (x1, (fa Q t)) :: G ->
       subTp G P (fa Q t) -> subTp (D0 ++ (x1, P) :: G) (S2 x0) (T2 x0))).
apply H3.
apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.

apply H3 with (D0 := (x0,T1)::D).
apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.

(* fa-rcd *)

intros. rewrite H7 in H5, H6, H1, H2; clear H7. clear G. 
apply sub_rcd.
apply subTp_preserves_okEnv with (fa Q t). assumption. assumption.
apply Gclosed_preserved with (fa Q t). assumption.
assumption. assumption.
intros. apply H6. assumption. reflexivity. assumption. 

(************************* RCD *************************)

apply mpx.

(*** Trans: rcd case ***)

intros. apply trans_rcd with L.
apply H. 
assumption. assumption. 

(*** Narrow: rcd case ***)

clear H. intro.
induction 1.

(* rcd-top *)

clear H.
intros. rewrite H in H0, H1; clear H. clear G.

apply sub_top.
apply subTp_preserves_okEnv with (rcd L). assumption. assumption.

apply Gclosed_preserved with (rcd L). assumption.

(* rcd-var *)

clear H. intros.
rewrite H in H0, H1; clear H. clear G.
elim (LEM_Var x x0).

intro. rewrite H. 
apply sub_var with P.
apply subTp_preserves_okEnv with (rcd L). assumption. assumption.
apply isinG_inside.

intro.
apply sub_var with U.
apply subTp_preserves_okEnv with (rcd L). assumption. assumption.
apply isinG_somewhere with (rcd L). assumption. assumption.

(* rcd-trs *)

intros. rewrite H2 in IHsubTp, H0, H1; clear H2. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H2. rewrite H2 in H0, H1, IHsubTp; clear H2 x0.
apply sub_trs with P.

apply isinG_inside.

apply H.

assert (G0 = (app nil G0)). simpl. reflexivity. rewrite H2; clear H2.
assert ((D ++ (x, P) :: nil ++ G0) = (D ++ (x, P) :: nil) ++ G0).
apply eq_sym. apply app_ass. rewrite H2; clear H2.

apply weakening. assumption. 

rewrite app_ass. apply subTp_preserves_okEnv with (rcd L).

apply subTp_ensures_okEnv with U T.
assumption. assumption.

assert (U = (rcd L)). 

rewrite (isinG_type x U D (rcd L) G0).
reflexivity. assumption. 
apply subTp_ensures_okEnv with U T. assumption.
rewrite H2 in IHsubTp; clear H2.

apply IHsubTp.
reflexivity. assumption. 

intro. 
apply sub_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 (rcd L). assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubTp. reflexivity. assumption.

(* rcd-arr *)

intros. rewrite H0 in IHsubTp1, IHsubTp2; clear H0. clear G H0_ H0_0. 

apply sub_arr.
apply IHsubTp1. reflexivity. assumption.
apply IHsubTp2. reflexivity. assumption.

(* rcd-fa *)

intros. rewrite H3 in H2, IHsubTp, H0, H1; clear H3. clear G. 

apply sub_fa.
apply IHsubTp. reflexivity. assumption.
intros.
assert ((forall (D0 : list (Var * Tp)) (x1 : Var) (G : list (Var * Tp)) (P : Tp),
       (x0, T1) :: D ++ (x, (rcd L)) :: G0 = D0 ++ (x1, (rcd L)) :: G ->
       subTp G P (rcd L) -> subTp (D0 ++ (x1, P) :: G) (S2 x0) (T2 x0))).
apply H2.
apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.

apply H2 with (D0 := (x0,T1)::D).
apply subTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.

(* rcd-rcd *)

intros. rewrite H6 in H4, H5, H0, H1; clear H6. clear G. 
apply sub_rcd.
apply subTp_preserves_okEnv with (rcd L). assumption. assumption.
apply Gclosed_preserved with (rcd L). assumption.
assumption. assumption.
intros. apply H5. assumption. reflexivity. assumption. 
Qed.