
Require Import Omega.

(* Starting properties *)

Inductive lntp: Tp -> nat -> Prop:=
    lntp_top : (lntp top (S O))
  | lntp_var : forall x: Var,
               (lntp x (S O))
  | lntp_arr : forall s t: Tp, forall n1 n2: nat,
               (lntp s n1) -> (lntp t n2) ->
               (lntp (arr s t) (S (plus n1 n2)))
  | lntp_fa  : forall s: Tp, forall t: Var -> Tp, forall n1 n2:nat,
               (lntp s n1) -> (forall x:Var, (lntp (t x) n2)) ->
               (lntp (fa s t) (S (plus n1 n2)))
  | lntp_rcd : forall l: list (Lab*Tp), forall n:nat,
               (lntp_list l n) -> (lntp (rcd l) n)

with lntp_list: list (Lab*Tp) -> nat -> Prop:=
    lntp_nil : (lntp_list nil (S 0))
  | lntp_cons: forall l: list (Lab*Tp), forall p: Lab*Tp, forall n1 n2:nat,
               (lntp (snd p) n1) -> (lntp_list l n2) ->
               (lntp_list (p :: l) (S (plus n1 n2))).

Section nat_ind_complete.

Lemma NAT_COMPLETE: forall P: nat->Prop,
                    (forall n: nat, (forall m: nat, (lt m n) -> (P m)) -> (P n)) ->
                    forall a b: nat, (lt b a) -> (P b).
do 2 intro.
induction a; intros.
inversion_clear H0.
inversion_clear H0.
apply H; intros; apply IHa; auto.
apply IHa; unfold lt; assumption.
Qed.

Lemma NAT_IND: forall P: nat->Prop,
               (P O) ->
               (forall n: nat, (forall m: nat, (lt m n) -> (P m)) -> (P n)) ->
               (forall n: nat, (P n)).
do 3 intro; induction n; intros.

assumption.

apply H0; intros.
inversion H1.
assumption.
apply NAT_COMPLETE with (S m0); [assumption | rewrite H2; assumption].
Qed.

End nat_ind_complete.

Lemma LNTP_S: forall s: Tp, forall n: nat,
              (lntp s n) -> (lt O n).
induction s; intros.

inversion_clear H.
omega.
inversion_clear H.
omega.
inversion_clear H.
cut (lt (0) n1); [intro | apply IHs1; assumption].
cut (lt (0) n2); [intro | apply IHs2; assumption].
omega.

inversion_clear H0; elim (unsat s); intros.
cut (lt (0) n2); [intro | apply H with x; auto].
omega.

(* records *)

inversion_clear H. inversion_clear H0.
omega. omega.
Qed.

Lemma LNTP_Slist: forall L: list(Lab*Tp), forall n: nat,
                  (lntp_list L n) -> (lt O n).
induction L; intros.

inversion_clear H.
omega.
inversion_clear H.
omega.
Qed.

Scheme lntp_tp_list := Minimality for lntp Sort Prop
  with lntp_list_tp := Minimality for lntp_list Sort Prop.

Lemma lntp_unique: forall T: Tp, forall n: nat,
                   lntp T n -> forall m: nat, lntp T m -> n=m.
intros until 1. (* pattern T, n. *)
apply lntp_tp_list with 
      (P:= (fun T:Tp => (fun n:nat =>
            forall m:nat, lntp T m -> n=m)))
      (P0:= (fun L:list(Lab*Tp) => (fun n:nat =>
            forall m:nat, lntp_list L m -> n=m))); intros.

inversion_clear H0. reflexivity.

inversion_clear H0. reflexivity.

inversion_clear H4. rewrite (H1 n0). rewrite (H3 n3). 
reflexivity. assumption. assumption.
   
inversion_clear H4. rewrite (H1 n0). 
elim (unsat (fa s t)). intro x; intros. rewrite (H3 x n3).
reflexivity. apply (H6 x). assumption.

inversion_clear H2. apply H1. assumption.

inversion_clear H0. reflexivity.

inversion_clear H4. rewrite (H1 n0). rewrite (H3 n3). 
reflexivity. assumption. assumption. 

assumption.
Qed.

Lemma lntp_list_unique: forall L: list(Lab*Tp), forall n: nat,
                        lntp_list L n -> forall m: nat, lntp_list L m -> n=m.
intros until 1. (* pattern L, n. *)
apply lntp_list_tp with 
      (P:= (fun T:Tp => (fun n:nat =>
            forall m:nat, lntp T m -> n=m)))
      (P0:= (fun L:list(Lab*Tp) => (fun n:nat =>
            forall m:nat, lntp_list L m -> n=m))); intros.

inversion_clear H0. reflexivity.

inversion_clear H0. reflexivity.

inversion_clear H4. rewrite (H1 n0). rewrite (H3 n3). 
reflexivity. assumption. assumption.
   
inversion_clear H4. rewrite (H1 n0). 
elim (unsat (fa s t)). intro x; intros. rewrite (H3 x n3).
reflexivity. apply (H6 x). assumption.

inversion_clear H2. apply H1. assumption.

inversion_clear H0. reflexivity.

inversion_clear H4. rewrite (H1 n0). rewrite (H3 n3). 
reflexivity. assumption. assumption. 

assumption.
Qed.

Lemma lntp_inv: forall p: Lab*Tp, forall L: list (Lab*Tp),
                forall n m: nat, 
                lntp (rcd (p::L)) m -> lntp (snd p) n -> 
                n < m.
intros. inversion_clear H. inversion H1.
rewrite (lntp_unique (snd p) n H0 n1).
omega. assumption.
Qed.

Lemma lntp_list_inv: forall p: Lab*Tp, forall L: list (Lab*Tp),
                     forall n m: nat, 
                     lntp (rcd (p::L)) m -> lntp_list L n -> 
                     n < m.
intros. inversion_clear H. inversion H1.
rewrite (lntp_list_unique L n H0 n2).
omega. assumption.
Qed.

Lemma LNTP_RW: forall n: nat,
               (forall s:Tp, (lntp s n) -> forall x:Var, forall t: Var->Tp,
               (notin_ho x t) -> s=(t x) ->
               forall y: Var, (lntp (t y) n))
               /\
               (forall L:list(Lab*Tp), (lntp_list L n) -> forall x:Var, forall M: Var->list(Lab*Tp),
               (notin_lTp_ho x M) -> L=(M x) ->
               forall y: Var, (lntp_list (M y) n)).
intro; pattern n; apply NAT_IND; split; intros.

cut (lt O (0)); [intro | apply LNTP_S with s; assumption].
inversion_clear H2.

cut (lt O (0)); [intro | apply LNTP_Slist with L; assumption].
inversion_clear H2.

inversion H0.

rewrite <-H3 in H2; cut (t=(fun z:Var => top)); [intro | apply tp_ext with x; [assumption | unfold notin_ho; intros; apply notin_top | rewrite H2; trivial]].
rewrite H5; apply lntp_top.

elim (LEM_Var x0 x); intros.
cut (t=var); [intro | apply tp_ext with x; [assumption | unfold notin_ho; intros; apply notin_var; assumption | rewrite <-H2; rewrite <-H3; rewrite H5; trivial]].
rewrite H6; apply lntp_var.
cut (t=(fun z:Var => x0)); [intro | apply tp_ext with x; [assumption | unfold notin_ho; intros; apply notin_var; auto | rewrite H3; auto]].
rewrite H6; apply lntp_var.

elim (tp_exp s0 x); elim (tp_exp t0 x); intros.
inversion_clear H7; inversion_clear H8.
rewrite <-H5 in H0; rewrite H10 in H0; rewrite H11 in H0; inversion H0.
rewrite H2 in H5; rewrite H10 in H5; rewrite H11 in H5; cut (t=(fun z:Var => (arr (x1 z) (x0 z)))); [intro | apply tp_ext with x; [assumption | unfold notin_ho; intros; apply notin_arr; [unfold notin_ho in H7; auto | unfold notin_ho in H9; auto] | rewrite H5; trivial]].
rewrite H16; apply lntp_arr.
apply H with s1 x; [omega | rewrite H8; rewrite <-H11; assumption | unfold notin_ho in H7; unfold notin_ho; intros; auto | assumption].
apply H with t1 x; [omega | rewrite H12; rewrite <-H10; assumption | unfold notin_ho in H9; unfold notin_ho; intros; auto | assumption].

elim (LEM_Var x y); intros.
rewrite <-H7; rewrite <-H2; rewrite H6; assumption.
elim (tp_exp s0 x); elim (ho_tp_exp t0 x); intros.
inversion_clear H8; inversion_clear H9.
rewrite <-H5 in H0; rewrite H11 in H0; rewrite H12 in H0; inversion H0.
rewrite H2 in H5; rewrite H11 in H5; rewrite H12 in H5; cut (t=(fun z:Var => fa (x1 z) (x0 z))); [intro | apply tp_ext with x].
rewrite H17; apply lntp_fa; intros.
elim (unsat (arr x (fa y t))); intros.
inversion_clear H18.
inversion_clear H19; inversion_clear H20.
inversion_clear H19.
apply H with (x1 x) x; [omega | rewrite <-H12; assumption | unfold notin_ho in H8; unfold notin_ho; intros; auto | trivial].
elim (unsat (arr x (arr y (fa x2 t)))); intros.
inversion_clear H18.
inversion_clear H19; inversion_clear H20.
inversion_clear H19; inversion_clear H21.
apply H with (x0 y x3) x3; [omega | idtac | rewrite H17 in H22; cut (notin x3 (fa (x1 y) (x0 y))); [intro | auto]; inversion_clear H21; unfold notin_ho; intros; auto | trivial].
change (lntp ((fun z:Var => (x0 z x3)) y) n2); apply H with (t0 x3) x; [omega | auto | unfold notin_ho in H10; unfold notin_ho; intros; cut (notin x (fa top (x0 y0))); [intro | auto]; inversion_clear H23; auto | rewrite H11; trivial].
assumption.
unfold notin_ho in H8; unfold notin_ho in H10; unfold notin_ho; intros.
cut (notin x (x1 y0)); [intro | auto].
cut (notin x (fa top (x0 y0))); [intro | auto].
inversion_clear H19.
apply notin_fa; intros; auto.
auto.

(* records *)

inversion_clear H3 in H4.

cut (t=(fun z:Var => rcd nil)).
intro. rewrite H3. apply lntp_rcd. apply lntp_nil.
apply tp_ext with x.
assumption. unfold notin_ho; intros. apply notin_rcd. apply notin_nil.
rewrite H4. auto.

destruct p.
elim (tp_exp t0 x). intro T; intros. inversion_clear H3.
elim (lTp_exp l0 x). intro L; intros. inversion_clear H3.
rewrite <- H4 in H0. rewrite H9 in H0. rewrite H11 in H0.

cut (t=(fun z:Var => (rcd ((l1, T z) :: L z)))).
intro. rewrite H3. apply lntp_rcd. apply lntp_cons.

unfold snd. apply H with t0 x.
simpl in H6. rewrite H9 in H6.
apply lntp_inv with (l1, T x) (L x). assumption. simpl. assumption. 
assumption. assumption. assumption.

apply H with l0 x.
apply lntp_list_inv with (l1, T x) (L x). assumption. rewrite <- H11. assumption. 
assumption. assumption. assumption. 

apply tp_ext with x.
assumption. 
unfold notin_ho; intros. apply notin_rcd. apply notin_2nd. split.
simpl. unfold notin_ho in H8. apply H8. assumption.
unfold notin_lTp_ho in H10. apply H10. assumption.
rewrite <- H9. rewrite <- H11. rewrite <- H2. auto.

(* 2nd path: lists *)

inversion H0.

rewrite <-H3 in H2. cut (M=(fun z:Var => nil)).
intro. rewrite H5. apply lntp_nil.
apply lTp_ext with x.
assumption. unfold notin_lTp_ho; intros. apply notin_nil. auto. 

destruct p.
elim (tp_exp t x). intro T; intros. inversion_clear H7.
elim (lTp_exp l x). intro N; intros. inversion_clear H7.
rewrite <- H5 in H0. rewrite H9 in H0. rewrite H11 in H0.

cut (M=(fun z:Var => ((l0, T z) :: N z))).
intro. rewrite H7. apply lntp_cons.

unfold snd. apply H with t x.
rewrite <- H6. omega.
assumption. assumption. assumption.

assert (forall m : nat, m < n0 ->
         (forall L : list (Lab * Tp),
         lntp_list L m ->
         forall (x : Var) (M : Var -> list (Lab * Tp)),
         notin_lTp_ho x M -> L = M x -> forall y : Var, lntp_list (M y) m)).
intros until 1. apply H. assumption. clear H.

apply H12 with l x.
rewrite <- H6. omega.
assumption. assumption. assumption.
 
apply lTp_ext with x.
assumption. 
unfold notin_lTp_ho; intros. apply notin_2nd. split.
simpl. unfold notin_ho in H8. apply H8. assumption.
unfold notin_lTp_ho in H10. apply H10. assumption.
rewrite <- H9. rewrite <- H11. rewrite <- H2. auto.
Qed.

Section Rcd2Tp.

Variable L T: Set.
Variable P: T -> Prop.

Fixpoint Rcd2Tp (M: list (L*T)): Prop := 
         match M with
         | nil => True
         | (cons (l,t) N) => P t /\ Rcd2Tp N
         end. 

End Rcd2Tp.

Section Tp_rec_ext.

Variable P: Tp -> Prop.

Hypothesis Top_case: P top.

Hypothesis Var_case: forall v: Var,
                     P v.

Hypothesis Arr_case: forall S T: Tp,
                     P S -> P T ->
                     P (arr S T).

Hypothesis Fa_case: forall S: Tp, forall t: Var->Tp,
                    P S -> (forall v: Var, P (t v)) ->
                    P (fa S t).

Hypothesis Rcd_case: forall L: list (Lab*Tp),
                     Rcd2Tp Lab Tp P L ->
                     P (rcd L).

Fixpoint Tp_rec_ext (T: Tp): P T :=
         match T with
         | top       => Top_case
         | var v     => Var_case v
         | arr T1 T2 => Arr_case T1 T2 
                                 (Tp_rec_ext T1)
                                 (Tp_rec_ext T2)
         | fa T1 T2  => Fa_case T1 T2 
                                (Tp_rec_ext T1) 
                                (fun v => (Tp_rec_ext (T2 v)))
         | rcd L     => Rcd_case L 
                        ((fix Tp_rec_list (M: list (Lab*Tp)): Rcd2Tp Lab Tp P M :=
                          match M with
                        | nil        => I
                        | (cons (l,t) N) => conj (Tp_rec_ext t)
                                                 (Tp_rec_list N)
                          end) L)
end.

End Tp_rec_ext.

Lemma Tp_ind_ext: forall P: Tp -> Prop,
       P top ->
       (forall v: Var, P v) ->
       (forall S: Tp, P S -> forall T: Tp, P T -> P (arr S T)) ->
       (forall S: Tp, P S -> forall t: Var -> Tp,
                 (forall v: Var, P (t v)) -> P (fa S t)) ->
       (forall L: list (Lab*Tp), 
                 (forall p: Lab*Tp, In p L -> P (snd p)) -> P (rcd L)) ->
       forall T: Tp, P T.

intros. induction T using Tp_rec_ext.
assumption.
apply H0.
apply H1. assumption. assumption.
apply H2. assumption. assumption.
apply H3. induction L.
intros. simpl in H5. contradiction.
intros. destruct a. destruct p. simpl in H4. 
inversion_clear H5.
rewrite <- H6. unfold snd. simpl in H4. tauto. 
apply IHL. tauto. assumption.
Qed. 

Lemma LNTP_TOT: (forall t:Tp, exists n:nat, lntp t n).

induction t using Tp_ind_ext; intros.

exists (S O); apply lntp_top.

exists (S O); apply lntp_var.

inversion_clear IHt1; inversion_clear IHt2; intros.
exists (S (x + x0)); apply lntp_arr; assumption.

elim (unsat (fa t t0)); intros.
inversion_clear IHt; intros.
cut (exists n : nat, lntp (t0 x) n); [intro | auto].
inversion_clear H2.
exists (S (x0+x1)); apply lntp_fa; intros; auto.
apply LNTP_RW with (t0 x) x; auto.
inversion_clear H0; auto.

induction L.

exists (S O); apply lntp_rcd; apply lntp_nil.

destruct a.

assert (exists n, lntp (snd (l, t)) n). apply H. simpl. tauto.
elim H0; clear H0. intro n; intros. 
assert (exists m, lntp (rcd L) m). apply IHL.
intros. apply H. simpl. tauto. 
elim H1; clear H1. intro m; intros.
exists (S (n + m)). apply lntp_rcd. apply lntp_cons.
assumption. inversion_clear H1. assumption.
Qed.

Lemma pre_notin_mono: forall n:nat, 
      (forall T:Tp, (lntp T n) ->
        forall U:Var->Tp, forall z:Var, (notin_ho z U) -> T=(U z) ->
        forall x y:Var, (notin x (U y)) -> (notin_ho x U)) /\
      (forall L:list(Lab*Tp), (lntp_list L n) ->
        forall M:Var->list(Lab*Tp), forall z:Var, (notin_lTp_ho z M) -> L=(M z) ->
        forall x y:Var, (notin_lTp x (M y)) -> (notin_lTp_ho x M)).
intro; pattern n; apply NAT_IND; split; intros.

cut (lt O (0)); [intro | apply LNTP_S with T; assumption].
inversion_clear H3.

cut (lt O (0)); [intro | apply LNTP_Slist with L; assumption].
inversion_clear H3.

inversion H0.

rewrite <-H4 in H2; cut (U=(fun z:Var => top)); [intro | apply tp_ext with z; try (apply notin_top; intros; apply notin_top); auto].
rewrite H6; unfold notin_ho; intros; apply notin_top.
unfold notin_ho; intros; apply notin_top.

elim (LEM_Var x0 z); intros.
 rewrite <- H4 in H2; rewrite H6 in H2.
   cut (U = var); [ intro | apply tp_ext with z; auto ].
  rewrite H7 in |- *; unfold notin_ho in |- *; intros; apply notin_var; auto.
 unfold notin_ho in |- *; intros; apply notin_var; auto.
rewrite <- H4 in H2.
  cut (U = (fun z : Var => x0)); [ intro | apply tp_ext with z; auto ].
 rewrite H7 in |- *; unfold notin_ho in |- *; intros; apply notin_var; auto.
   rewrite H7 in H3; inversion H3; auto.
unfold notin_ho in |- *; intros; apply notin_var; auto.

rewrite <-H6 in H2; elim (tp_exp s z); elim (tp_exp t z); intros.
inversion_clear H8; inversion_clear H9.
rewrite H11 in H2; rewrite H12 in H2.
cut (U=(fun z:Var => (arr (x1 z) (x0 z)))); [intro | apply tp_ext with z; try (unfold notin_ho in H8; unfold notin_ho in H10; unfold notin_ho; intros; apply notin_arr); auto].
rewrite H9; unfold notin_ho; intros; apply notin_arr.
cut (notin_ho x x1); [intro; unfold notin_ho in H14; auto | apply H with n1 (x1 z) z y; [rewrite <-H7; omega | apply LNTP_RW with (x1 z) z; [rewrite <-H12; assumption | assumption | trivial] | assumption | trivial | rewrite H9 in H3; inversion_clear H3; assumption]].
cut (notin_ho x x0); [intro; unfold notin_ho in H14; auto | apply H with n2 (x0 z) z y; [rewrite <-H7; omega | apply LNTP_RW with (x0 z) z; [rewrite <-H11; assumption | assumption | trivial] | assumption | trivial | rewrite H9 in H3; inversion_clear H3; assumption]].

rewrite <-H6 in H2; elim (tp_exp s z); elim (ho_tp_exp t z); intros.
inversion_clear H8; inversion_clear H9.
rewrite H11 in H2; rewrite H12 in H2.
cut (U=(fun z:Var => (fa (x1 z) (x0 z)))); [intro | apply tp_ext with z; auto].
rewrite H9; unfold notin_ho; intros; apply notin_fa; intros.
rewrite H9 in H3; inversion_clear H3.
cut (notin_ho x x1); [intro | auto].
unfold notin_ho in H3; auto.
apply H with n1 (x1 z) z y; auto.
omega.
rewrite <-H12; assumption.

elim (unsat (arr y1 (arr y0 (fa x (fun u:Var => (fa z (x0 u))))))); intros.
inversion_clear H15.
inversion_clear H16.
inversion_clear H17.
inversion_clear H16.
inversion_clear H18.
inversion_clear H16.

cut (notin_ho x (fun z:Var => (x0 z y1))); [intro; unfold notin_ho in H16; apply H16; auto | idtac].
apply H with n2 (x0 x2 y1) x2 y; auto.
omega.
elim (unsat (arr x2 (arr y1 (arr y0 (fa x (fun u:Var => (fa z (x0 u)))))))); intros.
inversion_clear H16.
inversion_clear H20.
inversion_clear H21.
inversion_clear H20.
inversion_clear H22.
inversion_clear H20.
inversion_clear H23.
inversion_clear H20.
apply LNTP_RW with (x0 x2 x3) x3; auto.
change (lntp ((fun z:Var => (x0 z x3)) x2) n2); apply LNTP_RW with (x0 z x3) z; auto.
rewrite <-H11; auto.
unfold notin_ho in H10; unfold notin_ho; intros.
cut (notin x3 (fa z (x0 x))); [intro | apply H24; auto].
inversion_clear H25; cut (notin z (fa top (x0 y2))); [intro | apply H10; auto].
inversion_clear H25; inversion_clear H26; auto.
cut (notin x3 (fa z (x0 x2))); [intro | auto].
inversion_clear H20; auto.
unfold notin_ho; intros.
cut (notin x2 (fa z (x0 y2))); [intro | auto].
inversion_clear H20; auto.
rewrite H9 in H3; inversion_clear H3; auto.
unfold notin_ho in H8; unfold notin_ho in H10; unfold notin_ho; intros.
cut (notin z (fa top (x0 y0))); [intro | apply H10; auto].
inversion_clear H13; apply notin_fa; intros; auto.

(* records *)

inversion_clear H4 in H5.

rewrite <- H5 in H2. cut (U=(fun z:Var => rcd nil)).
intro. rewrite H4. unfold notin_ho; intros.
apply notin_rcd. apply notin_nil.
apply tp_ext with z.
assumption. unfold notin_ho; intros. apply notin_rcd. apply notin_nil.
rewrite H2. reflexivity.

destruct p. rewrite <- H5 in H2.
elim (tp_exp t z). intro V; intros. inversion_clear H4.
elim (lTp_exp l0 z). intro L; intros. inversion_clear H4.
rewrite H10 in H2. rewrite H12 in H2.

cut (U=(fun z:Var => (rcd ((l1, V z) :: L z)))).
intro. rewrite H4. unfold notin_ho; intros. 
apply notin_rcd. apply notin_2nd.
rewrite H4 in H3. inversion_clear H3. inversion_clear H14.
inversion_clear H3. split.

unfold snd. apply H with n2 (V z) z y.
apply lntp_inv with (l1, V z) (L z).
rewrite <- H10. rewrite <- H12. rewrite H5. assumption.
rewrite <- H10. assumption. 
rewrite <- H10. assumption.
assumption. reflexivity. assumption. simpl in H14. assumption.

assert (forall m : nat, m < n0 ->
    (forall L : list (Lab * Tp),
     lntp_list L m ->
     forall (M : Var -> list (Lab * Tp)) (z : Var),
     notin_lTp_ho z M ->
     L = M z -> forall x y : Var, notin_lTp x (M y) -> notin_lTp_ho x M)).
intros until 1. apply H. assumption. clear H.

apply H3 with n3 (L z) z y.
apply lntp_list_inv with (l1, V z) (L z).
rewrite <- H10. rewrite <- H12. rewrite H5. assumption.
rewrite <- H12. assumption. 
rewrite <- H12. assumption.
assumption. reflexivity. assumption. assumption.

apply tp_ext with z.
assumption. 
unfold notin_ho; intros. apply notin_rcd. apply notin_2nd. split.
simpl. unfold notin_ho in H9. apply H9. assumption.
unfold notin_lTp_ho in H11. apply H11. assumption. auto.

(* 2nd path: lists *)

inversion H0.

rewrite <- H4 in H2. cut (M=(fun z:Var => nil)).
intro. rewrite H6. unfold notin_lTp_ho; intros. apply notin_nil.
apply lTp_ext with z.
assumption. unfold notin_lTp_ho; intros. apply notin_nil. auto. 

destruct p.
elim (tp_exp t z). intro T; intros. inversion_clear H8.
elim (lTp_exp l z). intro N; intros. inversion_clear H8.
rewrite <- H6 in H2. rewrite H10 in H2. rewrite H12 in H2.

cut (M=(fun z:Var => ((l0, T z) :: N z))).
intro. rewrite H8. unfold notin_lTp_ho; intros. apply notin_2nd. 
rewrite H8 in H3. inversion_clear H3. inversion_clear H14. split.

unfold snd. apply H with n1 (T z) z y. 
omega. rewrite <- H10. assumption. assumption. reflexivity.
assumption. assumption. 

assert (forall m : nat, m < n0 ->
    (forall L : list (Lab * Tp),
     lntp_list L m ->
     forall (M : Var -> list (Lab * Tp)) (z : Var),
     notin_lTp_ho z M ->
     L = M z -> forall x y : Var, notin_lTp x (M y) -> notin_lTp_ho x M)).
intros until 1. apply H. assumption. clear H.

apply H14 with n2 (N z) z y.
rewrite <- H7. omega.
rewrite <- H12. assumption. assumption. reflexivity.
assumption. assumption.
 
apply lTp_ext with z.
assumption. 
unfold notin_lTp_ho; intros. apply notin_2nd. split.
simpl. unfold notin_ho in H9. apply H9. assumption.
unfold notin_lTp_ho in H11. apply H11. assumption. auto.
Qed.

Lemma notin_mono: forall T: Var->Tp, forall x y: Var,
                  (notin x (T y)) ->
                  (forall z: Var, ~x=z -> (notin x (T z))).
intros.
elim (unsat (fa top T)); intros.
inversion_clear H1; clear H2.
elim (LNTP_TOT (T x0)); intros.
apply pre_notin_mono with x1 (T x0) x0 y; auto.
Qed.

Lemma pre_isin_mono: forall n:nat, 
      (forall T:Tp, (lntp T n) ->
        forall U:Var->Tp, forall z:Var, (notin_ho z U) -> T=(U z) ->
        forall x y:Var, ~x=y -> (isin x (U y)) ->
        forall v:Var, ~x=v -> (isin x (U v))) /\
      (forall L:list(Lab*Tp), (lntp_list L n) ->
        forall M:Var->list(Lab*Tp), forall z:Var, (notin_lTp_ho z M) -> L=(M z) ->
        forall x y:Var, ~x=y -> (isin_lTp x (M y)) ->
        forall v:Var, ~x=v -> (isin_lTp x (M v))).
intro; pattern n; apply NAT_IND; split; intros.

cut (lt O (0)); [intro | apply LNTP_S with T; assumption].
inversion_clear H5.

cut (lt O (0)); [intro | apply LNTP_Slist with L; assumption].
inversion_clear H5.

inversion H0.

rewrite <-H6 in H2; cut (U=(fun z:Var => top)); [intro | apply tp_ext with z; try (apply notin_top; intros; apply notin_top); auto].
rewrite H8 in H4; inversion_clear H4.
unfold notin_ho; intros; apply notin_top.

elim (LEM_Var x0 z); intros.
 rewrite <- H6 in H2; rewrite H8 in H2.
   cut (U = var); [ intro | apply tp_ext with z; auto ].
rewrite H9 in H4; inversion H4.
absurd (x=y); auto.
unfold notin_ho in |- *; intros; apply notin_var; auto.
rewrite <- H6 in H2.
  cut (U = (fun z : Var => x0)); [ intro | apply tp_ext with z; auto ].
rewrite H9 in H4; rewrite H9; assumption.
unfold notin_ho in |- *; intros; apply notin_var; auto.

rewrite <-H8 in H2; elim (tp_exp s z); elim (tp_exp t z); intros.
inversion_clear H10; inversion_clear H11.
rewrite H13 in H2; rewrite H14 in H2.
cut (U=(fun z:Var => (arr (x1 z) (x0 z)))); [intro | apply tp_ext with z; try (unfold notin_ho in H10; unfold notin_ho in H12; unfold notin_ho; intros; apply notin_arr); auto].
rewrite H11; apply isin_arr.
rewrite H11 in H4; inversion H4.
inversion_clear H16.
left; apply H with n1 (x1 z) z y; auto.
omega.
rewrite <-H14; assumption.
right; apply H with n2 (x0 z) z y; auto.
omega.
rewrite <-H13; assumption.

rewrite <-H8 in H2; elim (tp_exp s z); elim (ho_tp_exp t z); intros.
inversion_clear H10; inversion_clear H11.
rewrite H13 in H2; rewrite H14 in H2.
cut (U=(fun z:Var => (fa (x1 z) (x0 z)))); [intro | apply tp_ext with z; auto].
rewrite H11; apply isin_fa.
rewrite H11 in H4; inversion H4.
inversion_clear H16.
left; apply H with n1 (x1 z) z y; auto.
omega.
rewrite <-H14; assumption.

right; intros; elim (unsat (arr v (arr y0 (fa x (fun u:Var => (fa z (x0 u))))))); intros.
inversion_clear H19.
inversion_clear H20.
inversion_clear H21.
inversion_clear H20.
inversion_clear H22.
inversion_clear H20.

cut (forall w:Var, ~x=w -> isin x ((fun z:Var => (x0 z y0)) w)); [intro; apply H20; auto | idtac].
intros; change (isin x ((fun z:Var => x0 z y0) w)); apply H with n2 (x0 x2 y0) x2 y; auto.
omega.
elim (unsat (arr x2 (arr v (arr y0 (fa x (fun u:Var => (fa z (x0 u)))))))); intros.
inversion_clear H24.
inversion_clear H25.
inversion_clear H26.
inversion_clear H25.
inversion_clear H27.
inversion_clear H25.
inversion_clear H28.
inversion_clear H25.
apply LNTP_RW with (x0 x2 x3) x3; auto.
change (lntp ((fun z:Var => (x0 z x3)) x2) n2); apply LNTP_RW with (x0 z x3) z; auto.
rewrite <-H13; auto.
unfold notin_ho in H12; unfold notin_ho; intros.
cut (notin x3 (fa z (x0 x))); [intro | apply H29; auto].
inversion_clear H30; cut (notin z (fa top (x0 y1))); [intro | apply H12; auto].
inversion_clear H30; inversion_clear H31; auto.
cut (notin x3 (fa z (x0 x2))); [intro | auto].
unfold notin_ho; intros; inversion_clear H25; auto.
unfold notin_ho; intros.
cut (notin x2 (fa z (x0 y1))); [intro | auto].
inversion_clear H25; auto.
unfold notin_ho in H10; unfold notin_ho in H12; unfold notin_ho; intros.
cut (notin z (fa top (x0 y0))); [intro | apply H12; auto].
inversion_clear H15; apply notin_fa; intros; auto.

(* records *)

inversion_clear H6 in H7.

rewrite <- H7 in H2. cut (U=(fun z:Var => rcd nil)).
intro. rewrite H6 in H4. inversion_clear H4. inversion H9.
apply tp_ext with z.
assumption. unfold notin_ho; intros. apply notin_rcd. apply notin_nil.
rewrite H2. reflexivity.

destruct p. rewrite <- H7 in H2.
elim (tp_exp t z). intro V; intros. inversion_clear H6.
elim (lTp_exp l0 z). intro L; intros. inversion_clear H6.
rewrite H12 in H2. rewrite H14 in H2.

cut (U=(fun z:Var => (rcd ((l1, V z) :: L z)))).
intro. rewrite H6. apply isin_rcd. apply isin_2nd.
rewrite H6 in H4. inversion_clear H4. inversion_clear H15.
inversion_clear H4.

left. unfold snd. apply H with n2 (V z) z y.
apply lntp_inv with (l1, V z) (L z).
rewrite <- H12. rewrite <- H14. rewrite H7. assumption.
rewrite <- H12. assumption. 
rewrite <- H12. assumption.
assumption. reflexivity. assumption. simpl in H15. assumption. assumption.

right.
assert (forall m : nat, m < n0 ->
         (forall L : list (Lab * Tp),
         lntp_list L m ->
         forall (M : Var -> list (Lab * Tp)) (z : Var),
         notin_lTp_ho z M ->
         L = M z ->
         forall x y : Var,
         x <> y -> isin_lTp x (M y) -> forall v : Var, x <> v -> isin_lTp x (M v))).
intros until 1. apply H. assumption. clear H.

apply H4 with n3 (L z) z y.
apply lntp_list_inv with (l1, V z) (L z).
rewrite <- H12. rewrite <- H14. rewrite H7. assumption.
rewrite <- H14. assumption. 
rewrite <- H14. assumption.
assumption. reflexivity. assumption. assumption. assumption.

apply tp_ext with z.
assumption. 
unfold notin_ho; intros. apply notin_rcd. apply notin_2nd. split.
simpl. unfold notin_ho in H11. apply H11. assumption.
unfold notin_lTp_ho in H13. apply H13. assumption. auto.

(* 2nd path: lists *)

inversion H0.

rewrite <- H6 in H2. cut (M=(fun z:Var => nil)).
intro. rewrite H8 in H4. inversion H4.
apply lTp_ext with z.
assumption. unfold notin_lTp_ho; intros. apply notin_nil. auto. 

destruct p.
elim (tp_exp t z). intro T; intros. inversion_clear H10.
elim (lTp_exp l z). intro N; intros. inversion_clear H10.
rewrite <- H8 in H2. rewrite H12 in H2. rewrite H14 in H2.

cut (M=(fun z:Var => ((l0, T z) :: N z))).
intro. rewrite H10. apply isin_2nd. 
rewrite H10 in H4. inversion_clear H4. inversion_clear H15.

left. unfold snd. apply H with n1 (T z) z y. 
omega. rewrite <- H12. assumption. assumption. reflexivity.
assumption. assumption. assumption.

right.
assert (forall m : nat, m < n0 ->
         (forall L : list (Lab * Tp),
         lntp_list L m ->
         forall (M : Var -> list (Lab * Tp)) (z : Var),
         notin_lTp_ho z M ->
         L = M z ->
         forall x y : Var,
         x <> y -> isin_lTp x (M y) -> forall v : Var, x <> v -> isin_lTp x (M v))).
intros until 1. apply H. assumption. clear H.

apply H15 with n2 (N z) z y.
rewrite <- H9. omega.
rewrite <- H14. assumption. assumption. reflexivity.
assumption. assumption. assumption. 
 
apply lTp_ext with z.
assumption. 
unfold notin_lTp_ho; intros. apply notin_2nd. split.
simpl. unfold notin_ho in H11. apply H11. assumption.
unfold notin_lTp_ho in H13. apply H13. assumption. auto.
Qed.

Lemma isin_mono: forall T: Var->Tp, forall x y: Var,
                 ~x=y -> (isin x (T y)) ->
                 (forall z: Var, ~x=z -> (isin x (T z))).
intros.
elim (unsat (fa top T)); intros.
inversion_clear H2; clear H3.
elim (LNTP_TOT (T x0)); intros.
apply pre_isin_mono with x1 (T x0) x0 y; auto.
Qed.