Require Export syntax.

(* Typing environment: bookkeeping *)

Parameter envBook: Var -> Tp -> Prop.

Definition closed (T:Tp): Prop :=
           forall x:Var,
           (isin x T) -> exists U:Tp, (envBook x U).

(* Subtyping predicate - shallow version *)

Inductive subTp: Tp -> Tp -> Prop :=

          sub_top: forall S: Tp,
                    closed S -> subTp S top

        | sub_var: forall x: Var, forall U: Tp,
                    envBook x U -> subTp x x

        | sub_trs: forall x: Var, forall U T: Tp,
                    envBook x U -> subTp U T ->
                    subTp x T

        | sub_arr: forall S1 S2 T1 T2: Tp,
                    subTp T1 S1 -> subTp S2 T2 ->
                    subTp (arr S1 S2) (arr T1 T2)

        | sub_fa : forall S1 T1: Tp, forall S2 T2: Var->Tp,
                   forall L: list(Var),
                    subTp T1 S1 ->
                    (forall x:Var, (notin_list x L) ->
                                   (notin x S1) -> (notin x T1) ->
                                   (notin_ho x S2) -> (notin_ho x T2) ->
                                   envBook x T1 ->
                                   subTp (S2 x) (T2 x)) ->
                    subTp (fa S1 S2) (fa T1 T2).