Require Export ToC_deep.
Require Import List.

(* Auxiliary function: from (domains of) environments to lists of variables *)

Fixpoint envTp2list (G:envTp):=
match G with
  | nil => nil
  | (X,T)::G' => (cons X (envTp2list G'))
end.

Lemma freshList: forall G: envTp, forall x: Var, (notin_list x (envTp2list G)) -> Gfresh x G.

Proof.

induction G; intros.
 apply GfVoid.

 generalize H.
 clear H.
 case a; intros.
 inversion H.
 apply GfGrow.
  apply IHG; auto.

  assumption.

Qed.

(* subGTp derivations imply well-formed typing environments *)

Lemma subGTp_ensures_okEnv:
      forall G S T,
      subGTp G S T -> okEnv G.
induction 1.
assumption. assumption. assumption. assumption. assumption.
Qed.

(* Auxiliary function: from (domains of) environments to arrow types *)

Fixpoint domGtoT (G: envTp):= match G with
                              | nil => top
                              | (x,T)::G' => (arr x (domGtoT G'))
                              end.

(* subGTp derivations imply closedness w.r.t. the environment G (Scoping Lemma) *)

Lemma domGtoT_notin: forall G: envTp, forall x: Var,
                     notin x (domGtoT G) -> Gfresh x G.
induction G; intros.
 apply GfVoid.
generalize H.
  clear H.
  elim a; intros.
  apply GfGrow.
 apply IHG; auto.
   simpl in H.
   inversion H; assumption.
elim (LEM_Var x a0); intros.
 rewrite H0 in H; inversion_clear H.
   inversion_clear H1.
    absurd (a0 = a0); auto.
assumption.
Qed.

Lemma unsatG: forall G: envTp,
              exists x:Var, Gfresh x G.
intro; elim (unsat (domGtoT G)); intros; exists x; apply domGtoT_notin; assumption.
Qed.

Lemma Gclosed_lemma: forall G: envTp, forall S T: Tp,
                     subGTp G S T ->
                     Gclosed S G /\ Gclosed T G.
intros. assert (okEnv G).
apply subGTp_ensures_okEnv with S T. assumption.
generalize H0 H; clear H0 H.
generalize G S T; clear G S T.

induction 2; intros.
 split.
  assumption.
 unfold Gclosed in |- *; intros.
   inversion_clear H2.
unfold Gclosed in |- *; split; intros; inversion H2; exists U; assumption.
split.
 unfold Gclosed in |- *; intros.
   inversion H2.
   exists U; assumption.
 tauto.
unfold Gclosed in |- *; split; intros.
 inversion H2.
   inversion H4.
  cut (Gclosed T1 G /\ Gclosed S1 G); [ intro | auto ].
    inversion_clear H7.
    unfold Gclosed in H9.
    apply H9; auto.
 cut (Gclosed S2 G /\ Gclosed T2 G); [ intro | auto ].
   inversion_clear H7.
   unfold Gclosed in H8; apply H8; auto.
inversion H2.
  inversion H4.
 cut (Gclosed T1 G /\ Gclosed S1 G); [ intro | auto ].
   inversion_clear H7.
   unfold Gclosed in H8; apply H8; auto.
cut (Gclosed S2 G /\ Gclosed T2 G); [ intro | auto ].
  inversion_clear H7.
  unfold Gclosed in H9; apply H9; auto.

unfold Gclosed in |- *; split; intros.

 inversion H3.
   inversion H5.
  cut (Gclosed T1 G /\ Gclosed S1 G); [ intro | auto ].
    inversion_clear H8.
    unfold Gclosed in H10; apply H10; auto.
 elim (unsatG ((x, T1) :: G)); intros.
   cut (Gclosed (S2 x0) ((x0, T1) :: G) /\ Gclosed (T2 x0) ((x0, T1) :: G));
    [ intro | apply H2; auto ].
  inversion_clear H9.
    unfold Gclosed in H10.
    cut (exists U : Tp, isinG x U ((x0, T1) :: G));
     [ intro | apply H10; auto ].
   inversion H9.
     inversion H12.
     inversion H14.
    inversion_clear H17.
      inversion H8.
       absurd (x = x0).
     auto.
    auto.
   exists x1; assumption.
  apply H7; auto.
    inversion H8.
    auto.
 apply okGrow.
  auto.
 inversion H8; auto.
 cut (Gclosed T1 G /\ Gclosed S1 G); [ intro | apply IHsubGTp; assumption ].
    tauto.
 apply okGrow; auto.
  inversion H8; auto.
 cut (Gclosed T1 G /\ Gclosed S1 G); [ intro | apply IHsubGTp; assumption ].
    tauto.
 inversion H3.
   inversion H5.
  cut (Gclosed T1 G /\ Gclosed S1 G); [ intro | auto ].
    inversion_clear H8.
    unfold Gclosed in H9; apply H9; auto.
 elim (unsatG ((x, T1) :: G)); intros.
   cut (Gclosed (S2 x0) ((x0, T1) :: G) /\ Gclosed (T2 x0) ((x0, T1) :: G));
    [ intro | apply H2; auto ].
  inversion_clear H9.
    unfold Gclosed in H11.
    cut (exists U : Tp, isinG x U ((x0, T1) :: G));
     [ intro | apply H11; auto ].
   inversion H9.
     inversion H12.
     inversion H14.
    inversion_clear H17.
      inversion H8.
       absurd (x = x0).
     auto.
    auto.
   exists x1; assumption.
  apply H7; auto.
    inversion H8.
    auto.
 apply okGrow.
  auto.
 inversion H8; auto.
 cut (Gclosed T1 G /\ Gclosed S1 G); [ intro | apply IHsubGTp; assumption ].
    tauto.
 apply okGrow; auto.
  inversion H8; auto.
 cut (Gclosed T1 G /\ Gclosed S1 G); [ intro | apply IHsubGTp; assumption ].
    tauto.
Qed.
