
Require Import List.

(* Syntax of F< types *)

Parameter Var: Set.

Inductive Tp: Set := top: Tp
                  |  var: Var -> Tp
                  |  arr: Tp -> Tp -> Tp
                  |  fa : Tp -> (Var -> Tp) -> Tp.

Coercion var: Var >-> Tp.

(* Occur checking predicates *)

Inductive isin (x:Var): Tp -> Prop :=
          isin_var: isin x x
        | isin_arr: forall S T:Tp, 
                    isin x S \/ isin x T ->
                    isin x (arr S T)
        | isin_fa : forall S:Tp, forall T:Var->Tp,
                    isin x S \/ (forall y:Var, ~x=y -> isin x (T y)) ->
                    isin x (fa S T).

Inductive notin (x:Var): Tp -> Prop :=
          notin_top: notin x top
        | notin_var: forall y:Var, 
                     ~x=y ->
                     notin x y
        | notin_arr: forall s t:Tp, 
                     notin x s -> notin x t ->
                     notin x (arr s t)
        | notin_fa : forall s:Tp, forall t:Var->Tp,
                     (notin x s) -> 
                     (forall y:Var, ~x=y -> notin x (t y)) ->
                     notin x (fa s t).

Definition notin_ho:= fun x: Var => fun s: Var -> Tp => 
                      forall y: Var, x<>y -> (notin x (s y)).

Inductive notin_list (x:Var): list(Var) -> Prop :=
  notin_nil: notin_list x nil
| notin_cons: forall L: list(Var), forall y:Var, 
              x<>y -> (notin_list x L) -> (notin_list x (y::L)).
