
(* Auxiliary function: from lists of variables to arrow types *)

Fixpoint list2Tp (L:list(Var)):=
match L with
  | nil => top
  | X::L' => (arr X (list2Tp L'))
end.

(* Unsaturation lemmas *)

Lemma unsat_list: forall L: list(Var), forall x: Var, notin x (list2Tp L) -> notin_list x L.

Proof.

induction L; intros.
 apply notin_nil.

 simpl in H.
 inversion H.
 apply notin_cons.
  inversion H2; auto.

  auto.

Qed.

Lemma unsatEnv: forall t U:Tp, forall L: list(Var), exists x:Var, notin x t /\ notin x U /\ notin_list x L /\ envBook x U.

Proof.

intros; elim (unsat' (arr t (list2Tp L)) U ); intros.
inversion_clear H.
inversion_clear H0; inversion_clear H1.
exists x; split; try split; auto.
split.
apply unsat_list; assumption.
assumption.

Qed.

(* Scoping lemma for the shallow encoding *)

Lemma Scoping: forall S T: Tp, subTp S T -> closed S /\ closed T.

Proof.

induction 1; intros.
 split; auto.
 unfold closed; intros.
 inversion_clear H0.

 split; unfold closed; intros; inversion H0; exists U; auto.

 split.
  unfold closed; intros.
  inversion H1; exists U; auto.

  tauto.

 inversion_clear IHsubTp1; inversion_clear IHsubTp2; split; unfold closed;
  intros.
  inversion H5.
  inversion H7.
   unfold closed in H2.
   apply H2; auto.

   unfold closed in H3; apply H3; auto.

  inversion H5; inversion H7.
   unfold closed in H1; apply H1; auto.

   unfold closed in H4; apply H4; auto.

 inversion_clear IHsubTp; split.
  unfold closed; intros.
  inversion H4.
  inversion H6.
   unfold closed in H3; apply H3; auto.

   elim (unsatEnv (arr x (arr (fa S1 S2) (fa T1 T2))) T1 L); intros.
   inversion_clear H9.
   inversion_clear H10; inversion_clear H11.
   inversion_clear H9; inversion_clear H12; inversion_clear H13.
   inversion_clear H9; inversion_clear H14.
   assert (closed (S2 x0) /\ closed (T2 x0)).
    apply H1; auto.

    inversion H14.
    unfold closed in H18.
    apply H18; auto.


  unfold closed; intros.
  inversion H4.
  inversion H6.
   unfold closed in H2; apply H2; auto.

   elim (unsatEnv (arr x (arr (fa S1 S2) (fa T1 T2))) T1 L); intros.
   inversion_clear H9.
   inversion_clear H10; inversion_clear H11.
   inversion_clear H9; inversion_clear H12; inversion_clear H13.
   inversion_clear H9; inversion_clear H14.
   assert (closed (S2 x0) /\ closed (T2 x0)).
    apply H1; auto.

    inversion H14.
    unfold closed in H19.
    apply H19; auto.

Qed.