
(* Auxiliary function: from (codomains of) environments to arrow types *)

Fixpoint envTp2Tp (G:envTp):=
match G with
  | nil => top
  | (X,T)::G' => (arr X (arr T (envTp2Tp G')))
end.

(* Auxiliary lemmas: from shallow to deep *)

Lemma sub2book: forall S T: Tp, subTp S T -> forall x: Var, isin x S \/ isin x T -> exists U: Tp, envBook x U.

Proof.

induction 1; intros.
 inversion H0.
  unfold closed in H; auto.

  inversion_clear H1.

 inversion H0; inversion H1; exists U; auto.

 inversion H1.
  inversion H2.
  exists U; assumption.

  apply IHsubTp; auto.

 inversion H1; inversion H2.
  inversion H4.
   apply IHsubTp1; auto.

   apply IHsubTp2; auto.

  inversion H4.
   apply IHsubTp1; auto.

   apply IHsubTp2; auto.

 inversion H2.
  inversion H3.
  inversion H5.
   apply IHsubTp; auto.

elim (unsatEnv (arr x (arr (fa S1 S2) (fa T1 T2))) T1 L); intros.
inversion_clear H8.
   inversion_clear H9; inversion_clear H10.
   inversion_clear H11.
   inversion_clear H10; inversion_clear H13.
   apply H1 with x0; auto.
   inversion_clear H12; auto.
   inversion_clear H12; auto.
   left.
   inversion_clear H8; auto.

  inversion H3.
  inversion H5.
   apply IHsubTp; auto.

elim (unsatEnv (arr x (arr (fa S1 S2) (fa T1 T2))) T1 L); intros.
inversion_clear H8.
   inversion_clear H9; inversion_clear H10.
   inversion_clear H11.
   inversion_clear H10; inversion_clear H13.
   apply H1 with x0; auto.
   inversion_clear H12; auto.
   inversion_clear H12; auto.
   right.
   inversion_clear H8; auto.

Qed.

Lemma Gclosed_Gfresh: forall S: Tp, forall T: Var -> Tp, forall G: envTp, Gclosed (fa S T) G -> forall x: Var, Gfresh x G -> notin x S /\ notin_ho x T.

Proof.

intros; split.
 unfold Gclosed in H.
 elim (LEM_OC x S); intros.
  assert (exists U : Tp, isinG x U G).
   apply H.
   apply isin_fa; left; assumption.

   inversion H2.
   assert (x <> x).
    apply sepG with G x0; assumption.

    elim H4.
    trivial.

  assumption.

 unfold Gclosed in H; unfold notin_ho; intros.
 elim (LEM_OC x (T y)); intros.
  assert (exists U : Tp, isinG x U G).
   apply H.
   apply isin_fa; right; intros.
   apply isin_mono with y; auto.

   inversion H3.
   assert (x <> x).
    apply sepG with G x0; auto.

    elim H5.
    trivial.

  assumption.

Qed.

Inductive lnsub: envTp -> Tp -> Tp -> nat -> Prop:=
     lnsub_top : forall (G : envTp) (S : Tp),
                 okEnv G -> Gclosed S G -> lnsub G S top 1

   | lnsub_var : forall (G : envTp) (x : Var) (U : Tp),
                 okEnv G -> isinG x U G -> lnsub G x x 1

   | lnsub_trs : forall (G : envTp) (x : Var) (U T : Tp), forall n:nat,
                 isinG x U G -> lnsub G U T n -> lnsub G x T (n+1)

   | lnsub_arr : forall (G : envTp) (S1 S2 T1 T2 : Tp), forall n1 n2: nat,
                 lnsub G T1 S1 n1 ->
                 lnsub G S2 T2 n2 -> lnsub G (arr S1 S2) (arr T1 T2) ((plus n1 n2) + 1)

   | lnsub_fa  : forall (G : envTp) (S1 T1 : Tp) (S2 T2 : Var -> Tp), forall n1 n2:nat,
             lnsub G T1 S1 n1 ->
             (forall x : Var,
              okEnv ((x, T1) :: G) -> lnsub ((x, T1) :: G) (S2 x) (T2 x) n2) ->
             lnsub G (fa S1 S2) (fa T1 T2) ((plus n1 n2) + 1).

Lemma lnsub_S: forall G: envTp, forall s t: Tp, forall n: nat,
             (lnsub G s t n) -> (lt O n).

Proof.

induction n; intros.

inversion H.
absurd (n + 1 = 0); [omega | assumption].
absurd (n1 + n2 + 1 = 0); [omega | assumption].
absurd (n1 + n2 + 1 = 0); [omega | assumption].

inversion H; omega.

Qed.

Lemma lnsub2subGTp: forall n:nat, forall G: envTp, forall M N: Tp, lnsub G M N n -> subGTp G M N.

Proof.

intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply lnsub_S with G M N; assumption].
inversion_clear H0.

inversion H0.

apply subG_top; auto.

apply subG_var with U; auto.

apply subG_trs with U.
assumption.
apply H with n1.
omega.
assumption.

apply subG_arr.
apply H with n1.
omega.
assumption.
apply H with n2.
omega.
assumption.

apply subG_fa.
apply H with n1.
omega.
assumption.
intros.
apply H with n2.
omega.
apply H2; auto.

Qed.

Lemma unsat_envTp: forall G: envTp, forall x: Var, notin x (envTp2Tp G) -> notin_envTp x G.

Proof.

induction G.
 intros; apply notin_void.

 case a; intros.
 simpl in H.
 inversion_clear H.
 inversion_clear H0; inversion_clear H1.
 apply notin_grow; auto.

Qed.

Lemma notin_freshG: forall G: envTp, forall x: Var, notin x (envTp2Tp G) -> Gfresh x G.

Proof.

induction G.
 intros; apply GfVoid.

 case a; intros.
 inversion H.
 inversion_clear H2; inversion_clear H3.
 apply GfGrow; auto.

Qed.

Lemma envTp_exp: forall (G : envTp) (x : Var), exists G' : Var -> envTp, notin_envTp_ho x G' /\ G = (G' x).

Proof.

induction G.
 intros.
 exists (fun z : Var => nil); split; auto.
 unfold notin_envTp_ho; intros; apply notin_void.

 case a; intros.
 elim (IHG x); intros.
 inversion_clear H.
 elim (tp_exp t x); intros.
 inversion_clear H.
 elim (LEM_Var x v); intros.
  rewrite <- H.
  exists (fun z : Var => (z, x1 z) :: x0 z); split.
   unfold notin_envTp_ho; intros.
   apply notin_grow; auto.

   rewrite H3; rewrite H1; trivial.

  exists (fun z : Var => (v, x1 z) :: x0 z); split.
   unfold notin_envTp_ho; intros; apply notin_grow; auto.

   rewrite H1; rewrite H3; trivial.

Qed.

Inductive lnenvTp : envTp -> nat -> Prop :=
    lnenvTp_nil : lnenvTp nil 1
  | lnenvTp_cons : forall G: envTp, forall x : Var, forall U: Tp, forall n:nat, lnenvTp G n -> lnenvTp ((x,U)::G) (n+1).

Lemma LNENVTP_S: forall G: envTp, forall n: nat,
             (lnenvTp G n) -> (lt O n).

Proof.

induction G; intros.

inversion_clear H.
omega.
inversion_clear H.
omega.

Qed.

Lemma LNENVTP_TOT: forall G:envTp,
                exists n:nat, (lnenvTp G n).

Proof.

induction G.

intros; exists 1; apply lnenvTp_nil.

case a; inversion IHG; intros.
exists (x+1); apply lnenvTp_cons; auto.

Qed.

Lemma Gfresh_self: forall (n : nat) (G : envTp),
       lnenvTp G n ->
       forall (G' : Var -> envTp) (z : Var),
       notin_envTp_ho z G' ->
       G = G' z -> forall x: Var, notin_envTp_ho x G' -> Gfresh x (G' x) -> forall y: Var, x<>y -> notin_envTp_ho y G' -> Gfresh y (G' y).

Proof.

intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply LNENVTP_S with G; assumption].
inversion_clear H6.

inversion H0.

assert (G'=fun z:Var => nil).
apply envTp_ext with z; auto.
unfold notin_envTp_ho; intros; apply notin_void.
rewrite <-H2; auto.
rewrite H9; apply GfVoid.

elim (LEM_Var z x0); intros.
rewrite <-H10 in H8; rewrite <-H8 in H2.
elim (tp_exp U z); intros.
inversion_clear H11.
rewrite H13 in H2.
elim (envTp_exp G0 z); intros.
inversion_clear H11.
rewrite H15 in H2.
assert (G'=fun u:Var => (u, (x1 u))::(x2 u)).
apply envTp_ext with z; auto.
unfold notin_envTp_ho; intros; apply notin_grow; auto.
rewrite H11 in H4; inversion_clear H4.
absurd (x=x); auto.

elim (tp_exp U z); intros.
inversion_clear H11.
rewrite <-H8 in H2; rewrite H13 in H2.
elim (envTp_exp G0 z); intros.
inversion_clear H11.
rewrite H15 in H2.
assert (G'=fun u:Var => (x0, (x1 u))::(x2 u)).
apply envTp_ext with z; auto.
unfold notin_envTp_ho; intros; apply notin_grow; auto.
rewrite H11.
apply GfGrow; auto.
apply H with n1 (x2 z) z x; auto.
omega.
rewrite <-H15; assumption.
rewrite H11 in H3; unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros.
assert (notin_envTp x ((x0, x1 y0) :: x2 y0)); auto.
inversion_clear H17; assumption.
rewrite H11 in H4; inversion H4; assumption.
rewrite H11 in H6; unfold notin_envTp_ho in H6; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((x0, x1 y0) :: x2 y0)); auto.
inversion_clear H17; assumption.
rewrite H11 in H6; unfold notin_envTp_ho in H6.
assert (notin_envTp y ((x0, x1 x) :: x2 x)); auto.
inversion H16; assumption.

Qed.

Lemma Gfresh_self': forall (G : envTp),
       forall (G' : Var -> envTp) (z : Var),
       notin_envTp_ho z G' ->
       G = G' z -> forall x: Var, notin_envTp_ho x G' -> Gfresh x (G' x) -> forall y: Var, x<>y -> notin_envTp_ho y G' -> Gfresh y (G' y).

Proof.

intros; elim (LNENVTP_TOT G); intros.
apply Gfresh_self with x0 G z x; auto.

Qed.

Lemma Gfresh_self'': forall (n : nat) (G : envTp),
       lnenvTp G n -> forall (G' : Var -> envTp) (x:Var),
       G = G' x -> notin_envTp_ho x G' -> Gfresh x (G' x) -> forall y: Var, x<>y -> notin_envTp_ho y G' -> Gfresh y (G' y).

Proof.

intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply LNENVTP_S with G; assumption].
inversion_clear H5.

inversion H0.

assert (G'=fun z:Var => nil).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; apply notin_void.
rewrite <-H1; auto.
rewrite H8; apply GfVoid.

elim (LEM_Var x x0); intros.
rewrite <-H9 in H7; rewrite <-H7 in H1.
elim (tp_exp U x); intros.
inversion_clear H10.
rewrite H12 in H1.
elim (envTp_exp G0 x); intros.
inversion_clear H10.
rewrite H14 in H1.
assert (G'=fun u:Var => (u, (x1 u))::(x2 u)).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; apply notin_grow; auto.
rewrite H10 in H3; inversion_clear H3.
absurd (x=x); auto.

elim (tp_exp U x); intros.
inversion_clear H10.
rewrite <-H7 in H1; rewrite H12 in H1.
elim (envTp_exp G0 x); intros.
inversion_clear H10.
rewrite H14 in H1.
assert (G'=fun u:Var => (x0, (x1 u))::(x2 u)).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; apply notin_grow; auto.
rewrite H10.
apply GfGrow; auto.
apply H with n1 (x2 x) x; auto.
omega.
rewrite <-H14; assumption.
rewrite H10 in H3; inversion H3; assumption.
rewrite H10 in H5; unfold notin_envTp_ho in H5; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((x0, x1 y0) :: x2 y0)); auto.
inversion_clear H16; assumption.
rewrite H10 in H5; unfold notin_envTp_ho in H5; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((x0, x1 x) :: x2 x)); auto.
inversion_clear H15; assumption.

Qed.

Lemma Gfresh_self''': forall (G : envTp),
       forall (G' : Var -> envTp) (x : Var),
       notin_envTp_ho x G' ->
       G = G' x -> Gfresh x (G' x) -> forall y: Var, x<>y -> notin_envTp_ho y G' -> Gfresh y (G' y).

Proof.

intros; elim (LNENVTP_TOT G); intros.
apply Gfresh_self'' with x0 G x; auto.

Qed.

Lemma Gfresh_rw: forall G: envTp, forall G': Var -> envTp, forall z: Var, notin_envTp_ho z G' -> G=(G' z) -> forall x: Var, x<>z -> Gfresh x G -> forall y: Var, x<>y -> Gfresh x (G' y).

Proof.

induction G.

intros; assert (G'=(fun u:Var => nil)).
apply envTp_ext with z; auto.
unfold notin_envTp_ho; intros; apply notin_void.
rewrite H4; apply GfVoid.

case a; intros.
elim (tp_exp t z); intros.
inversion_clear H4.
rewrite H6 in H0.
elim (envTp_exp G z); intros.
inversion_clear H4.
rewrite H8 in H0.
elim (LEM_Var z v); intros.
rewrite <-H4 in H0.
assert (G'=(fun u:Var => (u, x0 u)::(x1 u))).
apply envTp_ext with z; auto.
unfold notin_envTp_ho; intros; unfold notin_ho in H5; unfold notin_envTp_ho in H7; apply notin_grow; auto.
rewrite H9.
apply GfGrow; auto.
apply IHG with z; auto.
inversion H2; assumption.
assert (G'=(fun u:Var => (v, x0 u)::(x1 u))).
apply envTp_ext with z; auto.
unfold notin_envTp_ho; intros; unfold notin_ho in H5; unfold notin_envTp_ho in H7; apply notin_grow; auto.
rewrite H9.
apply GfGrow; auto.
apply IHG with z; auto.
inversion H2; assumption.
inversion H2; auto.

Qed.

Lemma okEnv_notin: forall G G': envTp, forall x: Var, forall U: Tp, okEnv G -> G=(x,U)::G' -> notin x U.

Proof.

intros.
rewrite H0 in H; inversion H.
assert (notin x U /\ notin_ho x (fun z : Var => z)).
 apply Gclosed_Gfresh with G'; auto.
 unfold Gclosed; intros.
 inversion_clear H7.
 inversion_clear H8.
  unfold Gclosed in H6.
  apply H6; auto.

  elim (unsat x1); intros.
  inversion_clear H8.
  assert (isin x1 x2); auto.
  inversion H8; absurd (x1 = x2); auto.

 tauto.

Qed.

Lemma isinG_rwU: forall (n : nat), forall G: envTp,
       lnenvTp G n -> okEnv G -> forall U : Tp, forall G': Var -> envTp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> isinG x U G -> forall y: Var, x<>y -> notin_envTp_ho y G' -> isinG y U (G' y).

Proof.

intro; pattern n; apply NAT_IND.

intros; cut (lt O (0)); [intro | apply LNENVTP_S with G; assumption].
inversion_clear H6.

intros; inversion H0.

rewrite <-H7 in H4; inversion_clear H4.

elim (LEM_Var x0 x); intros.

rewrite H10 in H8.
assert (notin x U0).
apply okEnv_notin with ((x,U0)::G0) G0; auto.
rewrite H8; assumption.
elim (envTp_exp G0 x); intros.
inversion_clear H12.
rewrite H14 in H8.
rewrite <-H8 in H3.
assert (G'=(fun z:Var => (z, U0)::(x1 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H13; apply notin_grow; auto.
rewrite H12.
rewrite <-H8 in H4; inversion H4.
inversion_clear H16.
inversion_clear H19.
rewrite H20; apply checkG; left; auto.
apply checkG; right.
apply H with n1 G0 x; auto.
omega.
rewrite <-H8 in H1; inversion H1.
rewrite H14; assumption.
rewrite H14; assumption.
rewrite H12 in H6; unfold notin_envTp_ho in H6; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((y1, U0) :: x1 y1)); auto.
inversion_clear H20; auto.

elim (tp_exp U0 x); intros; elim (envTp_exp G0 x); intros.
inversion_clear H11; inversion_clear H12.
rewrite H14 in H8; rewrite H15 in H8; rewrite <-H8 in H3.
assert (G'=(fun z:Var => (x0,(x1 z))::(x2 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_ho in H13; unfold notin_envTp_ho in H11; apply notin_grow; auto.
rewrite H12.
rewrite H12 in H6; unfold notin_envTp_ho in H6; assert (y<>x0).
assert (notin_envTp y ((x0, x1 x) :: x2 x)); auto.
inversion H16; auto.
apply checkG; right.
apply H with n1 G0 x; auto.
omega.
rewrite <-H8 in H1; inversion H1; rewrite H15; auto.
rewrite <-H8 in H4; inversion H4.
inversion_clear H18.
inversion_clear H21.
absurd (x=x0); auto.
rewrite H15; assumption.
unfold notin_envTp_ho; intros.
assert (notin_envTp y ((x0, x1 y0) :: x2 y0)); auto.
inversion_clear H18; assumption.

Qed.

Lemma isinG_rwU': forall G: envTp,
       okEnv G -> forall U : Tp, forall G': Var -> envTp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> isinG x U G -> forall y: Var, x<>y -> notin_envTp_ho y G' -> isinG y U (G' y).

Proof.

intros; elim (LNENVTP_TOT G); intros.
apply isinG_rwU with x0 G x; auto.

Qed.

Lemma isinG_rw': forall (n : nat), forall G: envTp,
       lnenvTp G n -> forall U : Tp, forall G': Var -> envTp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> isinG x U G -> forall y: Var, x<>y -> notin_envTp_ho y G' -> exists U' : Tp, isinG y U' (G' y).

Proof.

intro; pattern n; apply NAT_IND.

intros; cut (lt O (0)); [intro | apply LNENVTP_S with G; assumption].
inversion_clear H5.

intros; inversion H0.

rewrite <-H6 in H3; inversion_clear H3.

elim (envTp_exp G0 x); elim (tp_exp U0 x); intros.
inversion_clear H9; inversion_clear H10.
rewrite H12 in H7; rewrite H13 in H7.
rewrite <-H7 in H2.

elim (LEM_Var x0 x); intros.

rewrite H10 in H2.
assert (G'=(fun z:Var => (z, (x1 z))::(x2 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H9; unfold notin_ho in H11; apply notin_grow; auto.
rewrite H14.
exists (x1 y); apply checkG; left; auto.

assert (G'=(fun z:Var => (x0, (x1 z))::(x2 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H9; unfold notin_ho in H11; apply notin_grow; auto.
rewrite H14.
elim (LEM_Var x0 y); intros.
rewrite H15; exists (x1 y); apply checkG; left; auto.
assert (exists U':Tp, isinG y U' (x2 y)).
apply H with n1 G0 U x; auto.
omega.
rewrite <-H7 in H3; inversion H3.
inversion_clear H17.
inversion_clear H20; absurd (x=x0); auto.
rewrite H13; assumption.
rewrite H14 in H5; unfold notin_envTp_ho in H5; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((x0, x1 y0) :: x2 y0)); auto.
inversion_clear H17; assumption.
inversion H16.
exists x3; apply checkG; right; assumption.

Qed.

Lemma isinG_rw: forall G: envTp,
       forall U : Tp, forall G': Var -> envTp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> isinG x U G -> forall y: Var, x<>y -> notin_envTp_ho y G' -> exists U' : Tp, isinG y U' (G' y).

Proof.


intros; elim (LNENVTP_TOT G); intros.
apply isinG_rw' with x0 G U x; auto.

Qed.

Lemma isinG_rw'': forall (n : nat), forall G: envTp,
       lnenvTp G n -> forall U : Tp, forall G': Var -> envTp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> forall z:Var, x<>z -> isinG z U G -> forall y: Var, x<>y -> notin_envTp_ho y G' -> exists U' : Tp, isinG z U' (G' y).

Proof.

intro; pattern n; apply NAT_IND.

intros; cut (lt O (0)); [intro | apply LNENVTP_S with G; assumption].
inversion_clear H6.

intros; inversion H0.

rewrite <-H7 in H4; inversion_clear H4.

elim (envTp_exp G0 x); elim (tp_exp U0 x); intros.
inversion_clear H10; inversion_clear H11.
rewrite H13 in H8; rewrite H14 in H8.
rewrite <-H8 in H2.

elim (LEM_Var x0 x); intros.

rewrite H11 in H2.
assert (G'=(fun z:Var => (z, (x1 z))::(x2 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H10; unfold notin_ho in H12; apply notin_grow; auto.
rewrite H15.
rewrite <-H8 in H4; inversion H4.
inversion_clear H17.
inversion_clear H20.
absurd (x=z); auto.
rewrite H17; auto.
assert (exists U' : Tp, isinG z U' (x2 y)).
apply H with n1 (x2 x) U x; auto.
omega.
rewrite <-H14; assumption.
rewrite H15 in H6; unfold notin_envTp_ho in H6; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((y1, x1 y1) :: x2 y1)); auto.
inversion_clear H21; assumption.
inversion_clear H17.
exists x3; apply checkG; right; assumption.
assert (G'=(fun z:Var => (x0, (x1 z))::(x2 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H10; unfold notin_ho in H12; apply notin_grow; auto.
rewrite H15.
rewrite <-H8 in H4; inversion H4.
inversion_clear H17.
inversion_clear H20.
rewrite H17; exists (x1 y); apply checkG; left; auto.
assert (exists U' : Tp, isinG z U' (x2 y)).
apply H with n1 G0 U x; auto.
omega.
rewrite H14; assumption.
rewrite H15 in H6; unfold notin_envTp_ho in H6; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((x0, x1 y1) :: x2 y1)); auto.
inversion_clear H21; assumption.
inversion H17.
exists x3; apply checkG; right; assumption.

Qed.

Lemma isinG_rw''': forall G: envTp,
       forall U : Tp, forall G': Var -> envTp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> forall z:Var, x<>z -> isinG z U G -> forall y: Var, x<>y -> notin_envTp_ho y G' -> exists U' : Tp, isinG z U' (G' y).

Proof.

intros; elim (LNENVTP_TOT G); intros.
apply isinG_rw'' with x0 G U x; auto.

Qed.

Lemma isin_self: forall n: nat, forall M:Tp, lntp M n -> forall M':Var -> Tp, forall x: Var, notin_ho x M' -> M=(M' x) -> isin x M -> forall y:Var, x<>y -> notin_ho y M' -> isin y (M' y).

Proof.

intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply LNTP_S with M; assumption].
inversion_clear H5.

inversion H0.

rewrite <-H6 in H3; inversion_clear H3.

elim (LEM_Var x0 x); intros.
rewrite H8 in H6; rewrite <- H6 in H2.
assert (M'=(fun z:Var => z)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
rewrite H9; apply isin_var; auto.

rewrite <- H6 in H3; inversion H3.
absurd (x=x0); auto.

elim (tp_exp s x); elim (tp_exp t x); intros.
inversion_clear H10; inversion_clear H11.
rewrite H13 in H8; rewrite H14 in H8; rewrite <-H8 in H2.
assert (M'=(fun z:Var => arr (x1 z) (x0 z))).
apply tp_ext with x; auto.
unfold notin_ho; intros; unfold notin_ho in H12; unfold notin_ho in H10; apply notin_arr; auto.
rewrite H11; apply isin_arr.
rewrite <-H8 in H3; inversion_clear H3.
inversion_clear H15.
left; apply H with n1 s x; auto.
omega.
rewrite H14; assumption.
rewrite H11 in H5; unfold notin_ho in H5; unfold notin_ho; intros.
assert (notin y (arr (x1 y0) (x0 y0))); auto.
inversion_clear H16; auto.
right; apply H with n2 t x; auto.
omega.
rewrite H13; assumption.
rewrite H11 in H5; unfold notin_ho in H5; unfold notin_ho; intros.
assert (notin y (arr (x1 y0) (x0 y0))); auto.
inversion_clear H16; auto.

elim (tp_exp s x); elim (ho_tp_exp t x); intros.
inversion_clear H10; inversion_clear H11.
rewrite H13 in H8; rewrite H14 in H8; rewrite <-H8 in H2.
assert (M'=(fun z:Var => (fa (x1 z) (x0 z)))).
apply tp_ext with x; auto.
unfold notin_ho; intros; unfold notin_ho in H10; unfold notin_ho in H12; apply notin_fa; intros; auto.
assert (notin x (fa top (x0 y0))); auto.
inversion_clear H16; auto.
rewrite <-H8 in H3; inversion H3.
inversion_clear H16.
rewrite H11; apply isin_fa; left.
apply H with n1 s x; auto.
omega.
rewrite H14; assumption.
rewrite H11 in H5; unfold notin_ho in H5; unfold notin_ho; intros.
assert (notin y (fa (x1 y0) (x0 y0))); auto.
inversion_clear H19; auto.
rewrite H11; apply isin_fa; right; intros.
elim (LEM_Var x y0); intros.
elim (unsat (arr x (arr y (fa (var y0) (fun z:Var => (x0 z z)))))); intros.
inversion_clear H20.
inversion_clear H21; inversion_clear H22.
inversion_clear H21; inversion_clear H23.
inversion_clear H21.
apply isin_mono with x2; auto.
change (isin y ((fun z:Var => (x0 z x2)) y)); apply H with n2 (x0 x x2) x; auto.
omega.
rewrite <-H13; auto.
unfold notin_ho; intros; unfold notin_ho in H12.
assert (notin x (fa top (x0 y1))); auto.
inversion_clear H25; auto.
rewrite H11 in H5; unfold notin_ho in H5; unfold notin_ho; intros.
assert (notin y (fa (x1 y1) (x0 y1))); auto.
inversion_clear H25; auto.
change (isin y ((fun z:Var => (x0 z y0)) y)); apply H with n2 (x0 x y0) x; auto.
omega.
rewrite <-H13; auto.
unfold notin_ho; intros; unfold notin_ho in H12.
assert (notin x (fa top (x0 y1))); auto.
inversion_clear H21; auto.
rewrite H11 in H5; unfold notin_ho in H5; unfold notin_ho; intros.
assert (notin y (fa (x1 y1) (x0 y1))); auto.
inversion_clear H21; auto.

Qed.

Lemma isin_self': forall M:Tp, forall M':Var -> Tp, forall x: Var, notin_ho x M' -> M=(M' x) -> isin x M -> forall y:Var, x<>y -> notin_ho y M' -> isin y (M' y).

Proof.

intros; elim (LNTP_TOT M); intros.
apply isin_self with x0 M x; auto.

Qed.

Lemma Gclosed_rw': forall (n : nat), forall t: Tp,
       lntp t n -> forall t': Var -> Tp, forall G: envTp, forall G': Var -> envTp, forall x: Var, notin_ho x t' -> t=(t' x) -> notin_envTp_ho x G' -> G=(G' x) -> Gclosed t G -> forall y: Var, x<>y -> notin_ho y t' -> notin_envTp_ho y G' -> Gclosed (t' y) (G' y).

Proof.

intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply LNTP_S with t; assumption].
inversion_clear H8.

inversion H0.

rewrite <-H9 in H2.
assert (t'=fun z:Var => top).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_top.
rewrite H11; unfold Gclosed; intros.
inversion_clear H12.

elim (LEM_Var x0 x); intros.

rewrite <-H9 in H2; rewrite H11 in H2.
assert (t'=(fun z:Var => z)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
rewrite H12; unfold Gclosed; intros.
inversion H13.
rewrite <-H9 in H5; rewrite H11 in H5; unfold Gclosed in H5.
assert (exists U : Tp, isinG x U G).
apply H5; apply isin_var; trivial.
rewrite H4 in H14; inversion H14.
apply isinG_rw with G x2 x; auto.
rewrite H4; assumption.

rewrite <-H9 in H2.
assert (t'=(fun z:Var => x0)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
rewrite H12; unfold Gclosed; intros.
inversion H13.
rewrite <-H9 in H5; unfold Gclosed in H5.
assert (exists U : Tp, isinG x0 U G).
apply H5; apply isin_var; trivial.
rewrite H4 in H14; inversion H14.
apply isinG_rw''' with G x2 x; auto.
rewrite H4; assumption.

elim (tp_exp s x); elim (tp_exp t0 x); intros.
inversion_clear H13; inversion_clear H14.
rewrite H16 in H11; rewrite H17 in H11.
rewrite <-H11 in H2.
assert (t'=(fun z:Var => (arr (x1 z) (x0 z)))).
apply tp_ext with x; auto.
unfold notin_ho; intros; unfold notin_ho in H13; unfold notin_ho in H15; apply notin_arr; auto.

rewrite H14; unfold Gclosed; intros.
inversion_clear H18.
inversion_clear H19.

assert (Gclosed (x1 y) (G' y)).
apply H with n1 s (G' x) x; auto.
omega.
rewrite H4 in H5; rewrite <-H11 in H5; unfold Gclosed in H5; unfold Gclosed; intros.
assert (exists U : Tp, isinG x3 U G).
rewrite H4; apply H5; auto.
rewrite H17 in H19; apply isin_arr; left; assumption.
rewrite <-H4; assumption.
rewrite H14 in H7; unfold notin_ho in H7; unfold notin_ho; intros.
assert (notin y (arr (x1 y0) (x0 y0))); auto.
inversion_clear H20; assumption.
unfold Gclosed in H19.
apply H19; auto.

assert (Gclosed (x0 y) (G' y)).
apply H with n2 t0 (G' x) x; auto.
omega.
rewrite H4 in H5; rewrite <-H11 in H5; unfold Gclosed in H5; unfold Gclosed; intros.
assert (exists U : Tp, isinG x3 U G).
rewrite H4; apply H5; auto.
rewrite H16 in H19; apply isin_arr; right; assumption.
rewrite <-H4; assumption.
rewrite H14 in H7; unfold notin_ho in H7; unfold notin_ho; intros.
assert (notin y (arr (x1 y0) (x0 y0))); auto.
inversion_clear H20; assumption.
unfold Gclosed in H19.
apply H19; auto.

elim (tp_exp s x); elim (ho_tp_exp t0 x); intros.
inversion_clear H13; inversion_clear H14.
rewrite H16 in H11; rewrite H17 in H11; rewrite <-H11 in H2.
assert (t'=(fun z:Var => fa (x1 z) (x0 z))).
apply tp_ext with x; auto.
unfold notin_ho; intros; unfold notin_ho in H13; unfold notin_ho in H15; apply notin_fa; intros; auto.
assert (notin x (fa top (x0 y0))); auto.
inversion_clear H19; auto.
rewrite H14; unfold Gclosed; intros.
inversion_clear H18.
inversion_clear H19.

assert (Gclosed (x1 y) (G' y)).
apply H with n1 s G x; auto.
omega.
rewrite <-H11 in H5; unfold Gclosed in H5; unfold Gclosed; intros.
rewrite H17 in H19; apply H5; auto.
apply isin_fa; left; assumption.
rewrite H14 in H7; unfold notin_ho in H7; unfold notin_ho; intros.
assert (notin y (fa (x1 y0) (x0 y0))); auto.
inversion_clear H20; assumption.
unfold Gclosed in H19; apply H19; auto.

elim (LEM_Var x2 y); intros.
rewrite <-H11 in H5; unfold Gclosed in H5.
elim (LEM_Var x2 x); intros.
absurd (x=y); auto.
rewrite <-H19; rewrite <-H20; trivial.

elim (unsat (arr x (arr y (arr x2 (fa top (fun z:Var => (fa top (x0 z)))))))); intros.
inversion_clear H21.
inversion_clear H22; inversion_clear H23.
inversion_clear H22; inversion_clear H24.
inversion_clear H22; inversion_clear H25.
assert (isin x2 (x0 y x3)); auto.
rewrite H19 in H25.
assert (isin x (x0 x x3)).
change (isin x ((fun z:Var => (x0 z x3)) x)); apply isin_self' with (x0 y x3) y; auto.
unfold notin_ho; intros; rewrite H14 in H7; unfold notin_ho in H7.
assert (notin y (fa (x1 y0) (x0 y0))); auto.
inversion_clear H28; auto.
unfold notin_ho; intros; unfold notin_ho in H15.
assert (notin x (fa top (x0 y0))); auto.
inversion_clear H28; auto.
assert (exists U : Tp, isinG x U G).
apply H5; auto.
apply isin_fa; right; intros.
apply isin_mono with x3; auto.
rewrite H4 in H28.
rewrite H19.
inversion H28.
apply isinG_rw with G x4 x; auto.
rewrite H4; assumption.

elim (unsat (arr x (arr y (arr x2 (fa top (fun z:Var => (fa top (x0 z)))))))); intros.
inversion_clear H20.
inversion_clear H21; inversion_clear H22.
inversion_clear H21; inversion_clear H23.
inversion_clear H21; inversion_clear H24.
elim (LEM_Var x2 x); intros.
absurd (x2=x); auto.
apply sepTp with (x0 y x3); auto.
unfold notin_ho in H15.
assert (notin x (fa top (x0 y))); auto.
inversion_clear H26; auto.

assert (isin x2 (x0 y x3)); auto.
rewrite <-H11 in H5; unfold Gclosed in H5.
assert (exists U : Tp, isinG x2 U G).
apply H5; auto.
apply isin_fa; right; intros.
apply isin_mono with x3; auto.
change (isin x2 ((fun z:Var => (x0 z x3)) x)); apply isin_mono with y; auto.
inversion H27.
apply isinG_rw''' with G x4 x; auto.

Qed.

Lemma Gclosed_rw: forall t: Tp,
       forall t': Var -> Tp, forall G: envTp, forall G': Var -> envTp, forall x: Var, notin_ho x t' -> t=(t' x) -> notin_envTp_ho x G' -> G=(G' x) -> Gclosed t G -> forall y: Var, x<>y -> notin_ho y t' -> notin_envTp_ho y G' -> Gclosed (t' y) (G' y).

Proof.

intros; elim (LNTP_TOT t); intros.
apply Gclosed_rw' with x0 t G x; auto.

Qed.

Lemma okEnv_rw: forall G: envTp, forall G': Var -> envTp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> okEnv G -> forall y: Var, x<>y -> notin_envTp_ho y G' -> okEnv (G' y).

Proof.

induction G.

intros; assert (G'=(fun z:Var => nil)).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; apply notin_void.
rewrite H4; apply okVoid.

case a; intros.
elim (envTp_exp G x); intros.
inversion_clear H4.
rewrite H6 in H0.
elim (tp_exp t x); intros.
inversion_clear H4.
rewrite H8 in H0.

elim (LEM_Var x v); intros.

rewrite <-H4 in H0.
assert (G'=(fun z:Var => (z,(x1 z))::(x0 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H5; unfold notin_ho in H7; apply notin_grow; auto.
rewrite <-H4 in H1; inversion H1.
rewrite H9; apply okGrow; auto.
apply IHG with x; auto.
rewrite H9 in H3; unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((y0, x1 y0) :: x0 y0)); auto.
inversion_clear H17; assumption.
apply Gfresh_self''' with G x; auto.
rewrite <-H6; assumption.
rewrite H9 in H3; unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((y0, x1 y0) :: x0 y0)); auto.
inversion_clear H17; assumption.
apply Gclosed_rw with t G x; auto.
rewrite H9 in H3; unfold notin_envTp_ho in H3; unfold notin_ho; intros.
assert (notin_envTp y ((y0, x1 y0) :: x0 y0)); auto.
inversion H17; auto.
rewrite H9 in H3; unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((y0, x1 y0) :: x0 y0)); auto.
inversion H17; auto.

assert (G'=(fun z:Var => (v,(x1 z))::(x0 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H5; unfold notin_ho in H7; apply notin_grow; auto.
inversion H1.
rewrite H9; apply okGrow; auto.
apply IHG with x; auto.
rewrite H9 in H3; unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((v, x1 y0) :: x0 y0)); auto.
inversion_clear H17; assumption.
apply Gfresh_rw with (x0 x) x; auto.
inversion H1.
rewrite <-H6; assumption.
rewrite H9 in H3; unfold notin_envTp_ho in H3.
assert (notin_envTp y ((v, x1 x) :: x0 x)); auto.
inversion H16; auto.

apply Gclosed_rw with t G x; auto.
rewrite H9 in H3; unfold notin_envTp_ho in H3; unfold notin_ho; intros.
assert (notin_envTp y ((v, x1 y0) :: x0 y0)); auto.
inversion H17; auto.
rewrite H9 in H3; unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((v, x1 y0) :: x0 y0)); auto.
inversion H17; auto.

Qed.

Lemma okEnv_notin2: forall G: envTp, okEnv G -> forall x: Var, forall U: Tp, isinG x U G -> notin x U.

Proof.

induction G.

intros.
inversion_clear H0.

case a; intros.
inversion H0.
inversion_clear H2.
inversion_clear H5.
rewrite <-H2 in H0; rewrite <-H6 in H0.
apply okEnv_notin with ((x,U)::G) G; auto.
rewrite H2; rewrite H6; assumption.
inversion H; apply IHG; auto.

Qed.

Lemma isinG_rwU2: forall (n : nat), forall G: envTp,
       lnenvTp G n -> okEnv G -> forall U : Tp, forall G': Var -> envTp, forall U': Var -> Tp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> notin_ho x U' -> U=(U' x) -> forall z: Var, x<>z -> isinG z U G -> forall y: Var, x<>y -> y<>z -> notin_envTp_ho y G' -> isinG z (U' y) (G' y).

Proof.

intro; pattern n; apply NAT_IND.

intros; cut (lt O (0)); [intro | apply LNENVTP_S with G; assumption].
inversion_clear H10.

intros; inversion H0.

rewrite <-H11 in H7; inversion_clear H7.

elim (LEM_Var x0 x); intros.

rewrite H14 in H12.
assert (notin x U0).
apply okEnv_notin with ((x,U0)::G0) G0; auto.
rewrite H12; assumption.
elim (envTp_exp G0 x); intros.
inversion_clear H16.
rewrite H18 in H12.
rewrite <-H12 in H3.
assert (G'=(fun z:Var => (z, U0)::(x1 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H17; apply notin_grow; auto.
rewrite H16.
apply checkG; right.
apply H with n1 G0 U x; auto.
omega.
rewrite <-H12 in H1; inversion H1.
rewrite H18; assumption.
rewrite <-H12 in H7; inversion H7.
inversion_clear H20.
inversion_clear H23.
absurd (z=x); auto.
rewrite H18; assumption.
rewrite H16 in H10; unfold notin_envTp_ho in H10; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((y0, U0) :: x1 y0)); auto.
inversion_clear H20; auto.

elim (tp_exp U0 x); intros.
inversion_clear H15.
rewrite H17 in H12.
elim (envTp_exp G0 x); intros.
inversion_clear H15.
rewrite H19 in H12.
rewrite <-H12 in H3.
assert (G'=(fun z:Var => (x0, (x1 z))::(x2 z))).
apply envTp_ext with x; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H18; unfold notin_ho in H16; apply notin_grow; auto.
rewrite <-H12 in H7; inversion H7.
inversion_clear H21.
inversion_clear H24.
rewrite H15; apply checkG; left; split; auto.
rewrite H5 in H25.
assert (U'=x1).
apply tp_ext with x; auto.
rewrite H24; trivial.
rewrite H15; apply checkG; right.
rewrite H5 in H24; apply H with n1 G0 U x; auto.
omega.
rewrite <-H12 in H1; inversion H1.
rewrite H19; assumption.
rewrite H5; rewrite H19; assumption.
rewrite H15 in H10; unfold notin_envTp_ho in H10; unfold notin_envTp_ho; intros.
assert (notin_envTp y ((x0, x1 y1) :: x2 y1)); auto.
inversion_clear H25; auto.

Qed.

Lemma isinG_rwU2': forall G: envTp,
       okEnv G -> forall U : Tp, forall G': Var -> envTp, forall U': Var -> Tp, forall x: Var, notin_envTp_ho x G' -> G=(G' x) -> notin_ho x U' -> U=(U' x) -> forall z: Var, x<>z -> isinG z U G -> forall y: Var, x<>y -> y<>z -> notin_envTp_ho y G' -> isinG z (U' y) (G' y).

Proof.

intros; elim (LNENVTP_TOT G); intros.
apply isinG_rwU2 with x0 G U x; auto.

Qed.

Lemma notin_envTp_Gfresh: forall G: envTp, forall x: Var, notin_envTp x G -> Gfresh x G.

Proof.

induction G.
 intros.
 apply GfVoid.

 case a; intros.
 inversion H; apply GfGrow.
  apply IHG; auto.

  assumption.

Qed.

Lemma lnsub_rw: forall n: nat, forall S T: Tp, forall x: Var, forall G: envTp, lnsub G S T n -> forall S' T': Var -> Tp, notin_ho x S' -> notin_ho x T' -> forall G': Var -> envTp, notin_envTp_ho x G' -> S=(S' x) -> T=(T' x) -> G=(G' x) -> forall y: Var, x<>y -> notin_ho y S' -> notin_ho y T' -> notin_envTp_ho y G' -> lnsub (G' y) (S' y) (T' y) n.

Proof.

intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply lnsub_S with G S  T; assumption].
inversion_clear H10.

inversion H0.

rewrite <-H15 in H5; assert (T'=(fun z:Var => top)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_top.
rewrite H17; apply lnsub_top.
apply okEnv_rw with G x; auto.
apply Gclosed_rw with S G x; auto.

elim (LEM_Var x0 x); intros.

rewrite H17 in H14; rewrite H17 in H15; rewrite <-H14 in H4; rewrite <-H15 in H5.
assert (S'=(fun z:Var => z)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
assert (T'=(fun z:Var => z)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
rewrite H18; rewrite H19.
assert (exists U':Tp, isinG y U' (G' y)).
apply isinG_rw with G U x; auto.
rewrite <-H17; assumption.
inversion H20.
apply lnsub_var with x1; auto.
apply okEnv_rw with G x; auto.

rewrite <-H14 in H4; rewrite <-H15 in H5.
assert (S'=(fun z:Var => x0)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
assert (T'=(fun z:Var => x0)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
rewrite H18; rewrite H19.
assert (exists U':Tp, isinG x0 U' (G' y)).
apply isinG_rw''' with G U x; auto.
inversion H20.
apply lnsub_var with x1; auto.
apply okEnv_rw with G x; auto.

elim (LEM_Var x0 x); intros.

rewrite H17 in H14; rewrite <-H14 in H4.
assert (S'=(fun z:Var => z)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
rewrite H18.

apply lnsub_trs with U; auto.
apply isinG_rwU' with G x; auto.
apply subGTp_ensures_okEnv with S T; auto.
apply lnsub2subGTp with n0; assumption.
rewrite <-H17; assumption.
change (lnsub (G' y) ((fun z:Var => U) y) (T' y) n1); apply H with U T x G; auto.
omega.
assert (notin x U).
apply okEnv_notin2 with G; auto.
apply subGTp_ensures_okEnv with S T; auto.
apply lnsub2subGTp with n0; assumption.
rewrite <-H17; assumption.
unfold notin_ho; intros; assumption.

assert (isinG y U (G' y)).
apply isinG_rwU' with G x; auto.
apply subGTp_ensures_okEnv with S T; auto.
apply lnsub2subGTp with n0; assumption.
rewrite <-H17; assumption.
unfold notin_ho; intros; apply okEnv_notin2 with (G' y); auto.
apply okEnv_rw with G x; auto.
apply subGTp_ensures_okEnv with S T; auto.
apply lnsub2subGTp with n0; assumption.

rewrite <-H14 in H4.
assert (S'=(fun z:Var => x0)).
apply tp_ext with x; auto.
unfold notin_ho; intros; apply notin_var; auto.
rewrite H18.
elim (tp_exp U x); intros.
inversion_clear H19.
apply lnsub_trs with (x1 y); auto.
apply isinG_rwU2' with G U x; auto.
apply subGTp_ensures_okEnv with S T; auto.
apply lnsub2subGTp with n0; assumption.
rewrite H18 in H8; unfold notin_ho in H8.
assert (notin y x0).
apply H8 with x; auto.
inversion_clear H19; auto.
apply H with U T x G; auto.
omega.
assert (Gfresh y G).
apply notin_envTp_Gfresh; auto.
unfold notin_envTp_ho in H10; rewrite H6; auto.
assert (Gclosed (fa U (fun z:Var => T)) G).
assert (Gclosed U G /\ Gclosed T G).
apply Gclosed_lemma; auto.
apply lnsub2subGTp with n1; auto.
inversion_clear H22; unfold Gclosed; intros.
inversion_clear H22.
inversion_clear H25.
unfold Gclosed in H23; unfold Gclosed in H24.
apply H23; auto.
unfold Gclosed in H23; unfold Gclosed in H24; elim (unsat x2); intros.
inversion_clear H25.
assert (isin x2 T).
apply H22 with x3; auto.
apply H24; auto.
assert (notin y U /\ notin_ho y (fun z:Var => T)).
apply Gclosed_Gfresh with G; auto.
inversion_clear H23.
rewrite H21 in H24.
unfold notin_ho; intros.
apply notin_mono with x; auto.

rewrite H4 in H14; rewrite H5 in H15.
elim (tp_exp S1 x); elim (tp_exp S2 x); elim (tp_exp T1 x); elim (tp_exp T2 x); intros.
inversion_clear H17; inversion_clear H18; inversion_clear H19; inversion_clear H20.
rewrite H24 in H14; rewrite H25 in H14; rewrite H22 in H15; rewrite H23 in H15.
assert (S'=(fun z:Var => arr (x3 z) (x2 z))).
apply tp_ext with x; auto.
unfold notin_ho; intros; unfold notin_ho in H19; unfold notin_ho in H18; apply notin_arr; auto.
assert (T'=(fun z:Var => arr (x1 z) (x0 z))).
apply tp_ext with x; auto.
unfold notin_ho; intros; unfold notin_ho in H21; unfold notin_ho in H17; apply notin_arr; auto.
rewrite H20; rewrite H26.
apply lnsub_arr.
apply H with T1 S1 x G; auto.
omega.
rewrite H26 in H9; unfold notin_ho in H9; unfold notin_ho; intros.
assert (notin y (arr (x1 y0) (x0 y0))); auto.
inversion_clear H28; auto.
rewrite H20 in H8; unfold notin_ho in H8; unfold notin_ho; intros.
assert (notin y (arr (x3 y0) (x2 y0))); auto.
inversion_clear H28; auto.
apply H with S2 T2 x G; auto.
omega.
rewrite H20 in H8; unfold notin_ho in H8; unfold notin_ho; intros.
assert (notin y (arr (x3 y0) (x2 y0))); auto.
inversion_clear H28; auto.
rewrite H26 in H9; unfold notin_ho in H9; unfold notin_ho; intros.
assert (notin y (arr (x1 y0) (x0 y0))); auto.
inversion_clear H28; auto.

rewrite H4 in H14; rewrite H5 in H15.
elim (tp_exp S1 x); elim (ho_tp_exp S2 x); elim (tp_exp T1 x); elim (ho_tp_exp T2 x); intros.
inversion_clear H17; inversion_clear H18; inversion_clear H19; inversion_clear H20.
rewrite H22 in H15; rewrite H23 in H15; rewrite H24 in H14; rewrite H25 in H14.
assert (S'=(fun z:Var => (fa (x3 z) (x2 z)))).
apply tp_ext with x; auto.
unfold notin_ho; intros; unfold notin_ho in H19; unfold notin_ho in H18; apply notin_fa; intros; auto.
assert (notin x (fa top (x2 y0))).
apply H18; assumption.
inversion_clear H27; auto.
assert (T'=(fun z:Var => (fa (x1 z) (x0 z)))).
apply tp_ext with x; auto.
unfold notin_ho; intros; unfold notin_ho in H17; unfold notin_ho in H21; apply notin_fa; intros; auto.
assert (notin x (fa top (x0 y0))).
apply H21; assumption.
inversion_clear H28; auto.

rewrite H20; rewrite H26.
apply lnsub_fa; intros.
apply H with (x1 x) (x3 x) x (G' x); auto.
omega.
rewrite <-H6; rewrite <-H23; rewrite <-H25.
assumption.
rewrite H26 in H9; unfold notin_ho in H9; unfold notin_ho; intros.
assert (notin y (fa (x1 y0) (x0 y0))).
apply H9; auto.
inversion_clear H28; assumption.
rewrite H20 in H8; unfold notin_ho in H8; unfold notin_ho; intros.
assert (notin y (fa (x3 y0) (x2 y0))).
apply H8; auto.
inversion_clear H28; assumption.
elim (unsat (arr x (arr y (arr x4 (arr (fa top x1) (arr (envTp2Tp (G' y)) (arr (envTp2Tp G) (arr (fa top (fun z:Var=>(fa top (x2 z)))) (fa top (fun z:Var=>(fa top (x0 z)))))))))))); intros.
inversion_clear H28.
inversion_clear H29; inversion_clear H30.
inversion_clear H29; inversion_clear H31.
inversion_clear H29; inversion_clear H32.
inversion_clear H29; inversion_clear H33.
inversion_clear H35.
inversion_clear H36.
inversion_clear H35; inversion_clear H37.

elim (LEM_Var x x4); intros.
rewrite <- H37; rewrite <- H37 in H27.
change (lnsub ((fun z:Var => ((z, x1 y) :: G' y)) x) (x2 y x) (x0 y x) n2).
apply H with (x2 y x5) (x0 y x5) x5 ((x5, (x1 y))::G' y); auto.
omega.
change (lnsub ((fun z:Var => ((x5, x1 z) :: G' z)) y) ((fun z:Var => (x2 z x5)) y) ((fun z:Var => (x0 z x5)) y) n2).
apply H with (x2 x x5) (x0 x x5) x ((x5, (x1 x))::G' x); auto.
omega.
rewrite <-H23; rewrite <-H6; rewrite <-H24; rewrite <-H22; apply H12; auto.

apply okGrow.
assert (okEnv G).
apply subGTp_ensures_okEnv with T1 S1.
apply lnsub2subGTp with n1; assumption.
assumption.
apply notin_freshG; assumption.
assert (Gclosed T1 G /\ Gclosed S1 G).
apply Gclosed_lemma; apply lnsub2subGTp with n1; assumption.
tauto.
unfold notin_ho; intros; rewrite H20 in H1; unfold notin_ho in H1.
assert (notin x (fa (x3 y0) (x2 y0))).
auto.
inversion_clear H41; auto.
unfold notin_ho; intros; rewrite H26 in H2; unfold notin_ho in H2.
assert (notin x (fa (x1 y0) (x0 y0))).
auto.
inversion_clear H41; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H3.
apply notin_grow; auto.
unfold notin_ho; intros; rewrite H20 in H8; unfold notin_ho in H8.
assert (notin y (fa (x3 y0) (x2 y0))).
auto.
inversion_clear H41; auto.
unfold notin_ho; intros; rewrite H26 in H9; unfold notin_ho in H9.
assert (notin y (fa (x1 y0) (x0 y0))).
auto.
inversion_clear H41; auto.
unfold notin_envTp_ho; intros; unfold notin_envTp_ho in H10.
apply notin_grow; auto.
rewrite H26 in H9; unfold notin_ho in H9.
assert (notin y (fa (x1 y0) (x0 y0))).
auto.
inversion_clear H41; auto.
assert (notin x5 (fa top (x2 y))).
auto.
inversion_clear H40; auto.
assert (notin x5 (fa top (x0 y))).
auto.
inversion_clear H40; auto.
unfold notin_envTp_ho; intros; apply notin_grow; auto.
apply unsat_envTp; assumption.
rewrite H20 in H1; unfold notin_ho in H1.
unfold notin_ho; intros.
assert (notin x (fa (x3 y) (x2 y))).
auto.
inversion_clear H41; auto.
rewrite H26 in H2; unfold notin_ho in H2.
unfold notin_ho; intros.
assert (notin x (fa (x1 y) (x0 y))).
auto.
inversion_clear H41; auto.
unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros.
apply notin_grow; auto.

elim (LEM_Var y x4); intros.
rewrite <-H40; rewrite <-H40 in H27.
change (lnsub ((fun z:Var => ((z, x1 z) :: G' z)) y) ((fun z:Var => (x2 z z)) y) ((fun z:Var => (x0 z z)) y) n2).
apply H with (x2 x x) (x0 x x) x ((x, (x1 x))::G' x); auto.
omega.
rewrite <-H23; rewrite <-H6; rewrite <-H24; rewrite <-H22; apply H12; auto.
apply okGrow; auto.
apply subGTp_ensures_okEnv with T1 S1; apply lnsub2subGTp with n1; assumption.
rewrite H6; apply Gfresh_self' with (G' y) y y; auto.
inversion H27; auto.
assert (Gclosed T1 G /\ Gclosed S1 G).
apply Gclosed_lemma; apply lnsub2subGTp with n1; auto.
tauto.
unfold notin_ho in H18; unfold notin_ho; intros.
assert (notin x (fa top (x2 y0))); auto.
inversion_clear H42; auto.
unfold notin_ho in H21; unfold notin_ho; intros.
assert (notin x (fa top (x0 y0))); auto.
inversion_clear H42; auto.
unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros.
unfold notin_ho in H17; apply notin_grow; auto.
rewrite H20 in H8; unfold notin_ho in H8; unfold notin_ho; intros.
assert (notin y (fa (x3 y0) (x2 y0))); auto.
inversion_clear H42; auto.
rewrite H26 in H9; unfold notin_ho in H9; unfold notin_ho; intros.
assert (notin y (fa (x1 y0) (x0 y0))); auto.
inversion_clear H42; auto.
unfold notin_envTp_ho in H10; unfold notin_envTp_ho; intros.
rewrite H26 in H9; unfold notin_ho in H9; apply notin_grow; auto.
assert (notin y (fa (x1 y0) (x0 y0))); auto.
inversion_clear H42; auto.

change (lnsub ((fun z:Var => ((x4, x1 z) :: G' z)) y) ((fun z:Var => (x2 z x4)) y) ((fun z:Var => (x0 z x4)) y) n2).
apply H with (x2 x x4) (x0 x x4) x ((x4, x1 x):: G' x); auto.
omega.
rewrite <-H23; rewrite <-H6; rewrite <-H24; rewrite <-H22; apply H12; auto.
apply okGrow; auto.
apply subGTp_ensures_okEnv with T1 S1; apply lnsub2subGTp with n1; assumption.
inversion H27.
rewrite H6; apply Gfresh_rw with (G' y) y; auto.
assert (Gclosed T1 G /\ Gclosed S1 G).
apply Gclosed_lemma; apply lnsub2subGTp with n1; auto.
tauto.
unfold notin_ho; intros; unfold notin_ho in H18.
assert (notin x (fa top (x2 y0))); auto.
inversion_clear H42; auto.
unfold notin_ho; intros; unfold notin_ho in H21.
assert (notin x (fa top (x0 y0))); auto.
inversion_clear H42; auto.
unfold notin_envTp_ho in H3; unfold notin_envTp_ho; intros; apply notin_grow; auto.
unfold notin_ho; intros; rewrite H20 in H8; unfold notin_ho in H8.
assert (notin y (fa (x3 y0) (x2 y0))); auto.
inversion_clear H42; auto.
rewrite H26 in H9; unfold notin_ho in H9; unfold notin_ho; intros.
assert (notin y (fa (x1 y0) (x0 y0))); auto.
inversion_clear H42; auto.
unfold notin_envTp_ho in H10; unfold notin_envTp_ho; intros; apply notin_grow; auto.
rewrite H26 in H9; unfold notin_ho in H9.
assert (notin y (fa (x1 y0) (x0 y0))); auto.
inversion_clear H42; auto.

Qed.

Lemma fresh2notin_envTp: forall G: envTp, okEnv G -> forall x:Var, Gfresh x G -> notin_envTp x G.

Proof.

induction G.
 intros.
 apply notin_void.

 case a; intros.
 inversion H; inversion H0.
 apply notin_grow; auto.
 assert (notin x t /\ notin_ho x (fun z : Var => t)).
  apply Gclosed_Gfresh with G.
   unfold Gclosed; intros; unfold Gclosed in H6.
   inversion H12; apply H6; auto.
   inversion_clear H14; auto.
   elim (unsat x1); intros.
   inversion H14; apply H16 with x2; auto.

   assumption.

  tauto.

Qed.

Lemma subGTp2lnsub: forall G: envTp, forall S T: Tp, subGTp G S T -> exists n:nat, lnsub G S T n.

Proof.

induction 1; intros.

exists 1; apply lnsub_top; auto.

exists 1; apply lnsub_var with U; auto.

inversion IHsubGTp.
exists (x0+1); apply lnsub_trs with U; auto.

inversion IHsubGTp1; inversion IHsubGTp2.
exists (x+x0+1); apply lnsub_arr; auto.

inversion IHsubGTp.
elim (unsat (arr (fa T1 T2) (arr (fa S1 S2) (envTp2Tp G)))); intros.
inversion_clear H3.
inversion_clear H4; inversion_clear H5.
inversion_clear H4.
assert (exists n : nat, lnsub ((x0, T1) :: G) (S2 x0) (T2 x0) n).
apply H1.
apply okGrow.
apply subGTp_ensures_okEnv with T1 S1; auto.
apply notin_freshG; auto.
assert (Gclosed T1 G /\ Gclosed S1 G).
apply Gclosed_lemma; assumption.
tauto.

inversion H4.
exists (x+x1+1); apply lnsub_fa; intros; auto.
elim (LEM_Var x0 x2); intros.
rewrite <-H11; assumption.
change (lnsub ((fun z:Var => ((z, T1) :: G)) x2) (S2 x2) (T2 x2) x1); apply lnsub_rw with (S2 x0) (T2 x0) x0 ((x0, T1) :: G); auto.
assert (okEnv ((x0, T1) :: G)).
apply subGTp_ensures_okEnv with (S2 x0) (T2 x0).
apply lnsub2subGTp with x1; assumption.
inversion H12; unfold notin_envTp_ho; intros; apply notin_grow; auto.
apply fresh2notin_envTp; assumption.
unfold notin_ho; intros.
apply notin_mono with x0; auto.
assert (Gclosed (S2 x0) ((x0, T1) :: G) /\ Gclosed (T2 x0) ((x0, T1) :: G)).
apply Gclosed_lemma; auto.
apply lnsub2subGTp with x1; assumption.
inversion_clear H13.
assert (Gclosed (fa (arr (S2 x0) (T2 x0)) (fun z:Var => top)) ((x0, T1) :: G)).
unfold Gclosed in H14; unfold Gclosed in H15; unfold Gclosed; intros.
inversion_clear H13.
inversion_clear H16.
inversion_clear H13.
inversion_clear H16.
apply H14; auto.
apply H15; auto.
elim (unsat x3); intros.
inversion_clear H16.
assert (isin x3 top).
apply H13 with x4; auto.
inversion_clear H16.
assert (notin x2 (arr (S2 x0) (T2 x0)) /\ notin_ho x2 (fun _ : Var => top)).
apply Gclosed_Gfresh with ((x0, T1) :: G); auto.
apply GfGrow; auto.
inversion H10; auto.
inversion_clear H16.
inversion_clear H17; auto.

unfold notin_ho; intros.
apply notin_mono with x0; auto.
assert (Gclosed (S2 x0) ((x0, T1) :: G) /\ Gclosed (T2 x0) ((x0, T1) :: G)).
apply Gclosed_lemma; auto.
apply lnsub2subGTp with x1; assumption.
inversion_clear H13.
assert (Gclosed (fa (arr (S2 x0) (T2 x0)) (fun z:Var => top)) ((x0, T1) :: G)).
unfold Gclosed in H14; unfold Gclosed in H15; unfold Gclosed; intros.
inversion_clear H13.
inversion_clear H16.
inversion_clear H13.
inversion_clear H16.
apply H14; auto.
apply H15; auto.
elim (unsat x3); intros.
inversion_clear H16.
assert (isin x3 top).
apply H13 with x4; auto.
inversion_clear H16.
assert (notin x2 (arr (S2 x0) (T2 x0)) /\ notin_ho x2 (fun _ : Var => top)).
apply Gclosed_Gfresh with ((x0, T1) :: G); auto.
apply GfGrow; auto.
inversion H10; auto.
inversion_clear H16.
inversion_clear H17; auto.

inversion H10; unfold notin_envTp_ho; intros.
apply notin_grow; auto.
apply fresh2notin_envTp; auto.
assert (notin x2 T1 /\ notin_ho x2 (fun z:Var => top)).
apply Gclosed_Gfresh with G; auto.
unfold Gclosed; intros; unfold Gclosed in H17.
inversion_clear H19.
inversion_clear H20.
apply H17; auto.
elim (unsat x4); intros.
inversion_clear H20; assert (isin x4 top).
apply H19 with x5; auto.
inversion_clear H20.
tauto.

Qed.

Lemma subGTp_rw': forall S T: Tp, forall x: Var, forall G: envTp, subGTp G S T -> forall S' T': Var -> Tp, notin_ho x S' -> notin_ho x T' -> forall G': Var -> envTp, notin_envTp_ho x G' -> S=(S' x) -> T=(T' x) -> G=(G' x) -> forall y: Var, x<>y -> notin_ho y S' -> notin_ho y T' -> notin_envTp_ho y G' -> subGTp (G' y) (S' y) (T' y).

Proof.

intros.
elim (subGTp2lnsub G S T H); intros.
assert (lnsub (G' y) (S' y) (T' y) x0).
apply lnsub_rw with S T x G; auto.
apply lnsub2subGTp with x0; assumption.

Qed.

Lemma subGTp_rw: forall S T: Var -> Tp, forall x: Var, forall U: Tp, forall G: envTp, notin_ho x S -> notin_ho x T -> subGTp ((x, U) :: G) (S x) (T x) -> forall y: Var, x<>y -> notin y U -> notin_ho y S -> notin_ho y T -> Gfresh y G -> subGTp ((y, U) :: G) (S y) (T y).

Proof.

intros.
change (subGTp ((fun z:Var => ((z, U) :: G)) y) (S y) (T y)); apply subGTp_rw' with (S x) (T x) x ((x,U)::G); auto.
assert (okEnv ((x, U) :: G)).
apply subGTp_ensures_okEnv with (S x) (T x); auto.
inversion H7.
assert (notin x U /\ notin_ho x (fun z:Var => top)).
apply Gclosed_Gfresh with G; auto.
unfold Gclosed in H13; unfold Gclosed; intros.
inversion_clear H14.
inversion_clear H15.
apply H13; auto.
elim (unsat x1); intros.
inversion_clear H15; assert (isin x1 top).
apply H14 with x2; auto.
inversion_clear H15.
inversion_clear H14; unfold notin_envTp_ho; intros; apply notin_grow; auto.
apply fresh2notin_envTp; auto.
unfold notin_envTp_ho; intros; apply notin_grow; auto.
apply fresh2notin_envTp; auto.
assert (okEnv ((x, U) :: G)).
apply subGTp_ensures_okEnv with (S x) (T x); auto.
inversion H8; auto.

Qed.

Lemma imp2exp': forall S T: Tp, subTp S T -> forall G: envTp, (okEnv G) -> (Gclosed S G) -> (Gclosed T G) -> (forall x: Var, forall U: Tp, envBook x U <-> isinG x U G) -> subGTp G S T.

Proof.

induction 1; intros.
 apply subG_top; auto.

 apply subG_var with U; auto.
 apply H3; auto.


 apply subG_trs with U; auto.
 apply H4; auto.
 apply IHsubTp; auto.
 unfold Gclosed; intros.
 assert (exists U : Tp, envBook x0 U).
  apply sub2book with U T; auto.

  inversion H6.
  exists x1.
  apply H4; auto.

 apply subG_arr; auto.
  apply IHsubTp1; auto.
   unfold Gclosed; intros.
   unfold Gclosed in H3.
   apply H3.
   apply isin_arr; left; assumption.

   unfold Gclosed; intros; unfold Gclosed in H2; apply H2; apply isin_arr;
    left; assumption.

  apply IHsubTp2; auto.
   unfold Gclosed; intros.
   unfold Gclosed in H2.
   apply H2.
   apply isin_arr; right; assumption.

   unfold Gclosed; intros; unfold Gclosed in H3; apply H3; apply isin_arr;
    right; assumption.

 apply subG_fa; intros.
  apply IHsubTp; auto.
   unfold Gclosed; intros; unfold Gclosed in H4; apply H4; apply isin_fa;
    left; assumption.
   unfold Gclosed; intros; unfold Gclosed in H3; apply H3; apply isin_fa;
    left; assumption.

elim (unsatEnv (arr (fa S1 S2) (arr (fa T1 T2) (arr x (list2Tp (envTp2list G))))) T1 L); intros.
inversion_clear H7.
inversion_clear H8; inversion_clear H9.
inversion_clear H7; inversion_clear H10; inversion_clear H11.
inversion_clear H7; inversion_clear H13.
inversion_clear H7.
apply subGTp_rw with x0; auto.
apply H1; auto.
apply okGrow; auto.
apply freshList; auto.
apply unsat_list; auto.
unfold Gclosed in H4; unfold Gclosed; intros.
apply H4; apply isin_fa; left; assumption.
unfold Gclosed in H3; unfold Gclosed; intros.
elim (LEM_Var x1 x0); intros.
rewrite H17; exists T1.
apply checkG.
left; auto.
assert (exists U : Tp, isinG x1 U G).
apply H3; auto.
apply isin_fa; right; intros.
apply isin_mono with x0; auto.
inversion H18.
exists x2; apply checkG; intros.
right; assumption.
unfold Gclosed in H4; unfold Gclosed; intros.
elim (LEM_Var x1 x0); intros.
rewrite H17; exists T1.
apply checkG.
left; auto.
assert (exists U : Tp, isinG x1 U G).
apply H4; auto.
apply isin_fa; right; intros.
apply isin_mono with x0; auto.
inversion H18.
exists x2; apply checkG; intros.
right; assumption.
intros; unfold iff; split; intros.
assert (isinG x1 U G).
apply H5; assumption.
apply checkG; right; assumption.
inversion H7.
inversion_clear H18.
inversion_clear H21.
rewrite H18; rewrite H22; assumption.
apply H5; assumption.
inversion_clear H6.
assert (notin x T1 /\ notin_ho x T2).
apply Gclosed_Gfresh with G; auto.
tauto.
inversion_clear H6.
assert (notin x S1 /\ notin_ho x S2).
apply Gclosed_Gfresh with G; auto.
tauto.
inversion_clear H6.
assert (notin x T1 /\ notin_ho x T2).
apply Gclosed_Gfresh with G; auto.
tauto.
inversion_clear H6.
assumption.

Qed.

Lemma closed_Gclosed: forall S T: Tp, subTp S T -> forall G: envTp, (okEnv G) -> (forall x: Var, forall U: Tp, envBook x U <-> isinG x U G) -> (Gclosed S G) /\ (Gclosed T G).

Proof.

intros.
assert (closed S /\ closed T).
 split.
  unfold closed; intros; apply sub2book with S T; auto.

  unfold closed; intros; apply sub2book with S T; auto.

 inversion_clear H2.
 unfold closed in H3; unfold closed in H4; unfold Gclosed; split; intros.
  assert (exists U : Tp, envBook x U); try apply H3; auto.
  inversion H5.
  exists x0; apply H1; auto.
  assert (exists U : Tp, envBook x U); try apply H4; auto.
  inversion H5.
  exists x0; apply H1; auto.

Qed.

(* Internal Adequacy *)

Lemma imp2exp: forall S T: Tp, subTp S T -> forall G: envTp, (okEnv G) -> (forall x: Var, forall U: Tp, envBook x U <-> isinG x U G) -> subGTp G S T.

Proof.

intros.
assert (Gclosed S G /\ Gclosed T G).
 apply closed_Gclosed; auto.

 inversion_clear H2; apply imp2exp'; auto.

Qed.