
(* Example: (Y<Top, Z<Y) =>
            VX<Top.X < VX<Z.Y *)

Lemma example_shallow: forall y z:Var,
                       envBook y top -> envBook z y ->
                       subTp (fa top (fun x:Var => x))
                             (fa z   (fun x:Var => y)).
intros. apply sub_fa with (y::z::nil).

apply sub_top.
unfold closed; intros.
inversion_clear H1.
exists y. assumption.

intros. apply sub_trs with z.
assumption.
apply sub_trs with y.
assumption.
apply sub_var with top. assumption.
Qed.

Lemma example_deep: forall y z:Var,
                    y <> z ->
                    subGTp ((z,(var y))::(y,top)::nil)
                           (fa top (fun x:Var => (arr top x)))
                           (fa z   (fun x:Var => (arr y y))).
intros. apply subG_fa.

apply subG_top.

(* extra okEnv *)

apply okGrow. apply okGrow. apply okVoid.
apply GfVoid. unfold Gclosed; intros. inversion H0.
apply GfGrow. apply GfVoid. auto.
unfold Gclosed; intros. inversion_clear H0.
exists top. apply checkG. tauto.

(**)

unfold Gclosed; intros.
inversion_clear H0.
exists y.

(* extra isinG *)

apply checkG. tauto.

(* vs. assumption *)

intros. apply subG_arr.

apply subG_top.
assumption. 

unfold Gclosed; intros.
inversion_clear H1.
exists top.

(* extra isinG *)

apply checkG. right.
apply checkG. right.
apply checkG. tauto.

(* vs. assumption *)

apply subG_trs with z.

(* extra isinG *)

apply checkG. tauto.

(* vs. assumption *)

apply subG_trs with y.

(* extra isinG *)

apply checkG. right.
apply checkG. tauto.

(* vs. assumption *)

apply subG_var with top. 

(* extra okEnv, but just assumption *)

assumption.

(**)

(* extra isinG *)

apply checkG. right.
apply checkG. right.
apply checkG. tauto.

(* vs. assumption *)

Qed.