
Require Import Permutation.

(* Deep environments machinery *)

(* Gfresh *)

Lemma Gfresh_preserved:
      forall D y x Q G P,
      Gfresh y (D ++ (x, Q) :: G) ->
      Gfresh y (D ++ (x, P) :: G).
induction D.

simpl. intros.
elim (LEM_Var y x).

intro. inversion_clear H. contradiction.
intro. inversion_clear H.
apply GfGrow. assumption. assumption.

simpl. intros. inversion_clear H.
apply GfGrow.
apply IHD with Q. assumption. assumption.
Qed.

Lemma Gfresh_preserved2:
      forall x D G,
      Gfresh x (D ++ G) ->
      Gfresh x G.
induction D.

simpl. tauto.

simpl. intros. inversion_clear H.
apply IHD. assumption.
Qed.

Lemma Gfresh_preserved3:
      forall x D G y U,
      Gfresh x (D ++ G) -> y <> x ->
      Gfresh x (D ++ (y, U) :: G).
induction D.

simpl. intros.
apply GfGrow. assumption. auto.

simpl. intros. inversion_clear H.
apply GfGrow.
apply IHD. assumption. assumption.
assumption.
Qed.

Lemma Gfresh_contradiction:
      forall D x T G,
      Gfresh x (D ++ (x, T) :: G) -> False.
induction D.

simpl. intros.
inversion_clear H. auto.

destruct a. simpl. intros. 
inversion_clear H. apply IHD with x T G. assumption.
Qed.

(* isinG *)

Lemma isinG_preserved:
      forall x U G D,
      isinG x U G ->
      isinG x U (D ++ G).
induction D.

simpl. tauto.

simpl. destruct a. intros.
apply checkG. right. 
apply IHD. assumption.
Qed.

Lemma isinG_inside:
      forall D x P G,
      isinG x P (D ++ (x, P) :: G).
induction D.

simpl. intros.
apply checkG. tauto.

case a; clear a. simpl. intros.
apply checkG.
right. apply IHD.
Qed. 

Lemma isinG_contradiction:
      forall G x S,
      isinG x S G -> Gfresh x G -> okEnv G -> False.
induction G.

intros. inversion_clear H.

destruct a. intros.
inversion_clear H. elim H2; clear H2.

intros. elim H; clear H. intros.
rewrite H in H0. inversion_clear H0. tauto.

intro. inversion_clear H0. inversion_clear H1.
apply IHG with x S. assumption. assumption. assumption.
Qed.

Lemma isinG_type:
      forall x S D T G,
      isinG x S (D ++ (x, T) :: G) -> okEnv (D ++ (x, T) :: G) ->
      S = T.
induction D.

simpl. intros.
inversion_clear H. elim H1; clear H1.

tauto.

intro. inversion_clear H0. clear H3.
assert False. apply isinG_contradiction with G x S.
assumption. assumption. assumption.
contradiction.

simpl. destruct a.
intros. inversion_clear H. elim H1; clear H1.

intro. elim H; clear H.
intros. rewrite H in H0. inversion_clear H0.
assert False. apply Gfresh_contradiction with D v T G. assumption. 
contradiction. 

intro. apply IHD with G. assumption. 
inversion_clear H0. assumption.
Qed.

Lemma isinG_somewhere:
      forall D y U x P G Q,
      isinG y U (D ++ (x, P) :: G) -> y <> x ->
      isinG y U (D ++ (x, Q) :: G).
induction D.

simpl. intros.
inversion_clear H. inversion_clear H1.

inversion_clear H. contradiction.
apply checkG. right. assumption.

simpl. intros. inversion_clear H. inversion_clear H1. 

inversion_clear H. apply checkG. left. tauto.
apply checkG. right.
apply IHD with P. assumption. assumption.
Qed.

Lemma isinG_neq:
      forall y T D x Q G,
      isinG y T (D ++ (x, Q) :: G) -> y <> x ->
      isinG y T (D ++ G).
induction D.

simpl. intros.
inversion_clear H. inversion_clear H1.

inversion_clear H. contradiction.
assumption.

simpl. intros. inversion_clear H. inversion_clear H1. 

inversion_clear H. apply checkG. left. tauto.
apply checkG. right.
apply IHD with x Q. assumption. assumption.
Qed.

Lemma isinG_neq2:
      forall y T D x Q G,
      isinG y T (D ++ G) -> y <> x ->
      isinG y T (D ++ (x, Q) :: G).
induction D.

simpl. intros.
apply checkG. right. assumption.

simpl. intros. inversion_clear H. inversion_clear H1. 

inversion_clear H. apply checkG. left. tauto.
apply checkG. right.
apply IHD. assumption. assumption.
Qed.

(* Gclosed *)

Lemma Gclosed_preserved_env:
      forall D S G,
      Gclosed S G ->
      Gclosed S (D ++ G).
unfold Gclosed. induction D. 

simpl. intros.
apply H. assumption.

destruct a. simpl. intros.
assert (exists U : Tp, isinG x U (D ++ G)).
apply IHD with S; clear IHD. assumption. 
clear H. assumption. 
elim H1; clear H1. intro T; intros.
exists T. apply checkG. right. assumption.
Qed.

Lemma Gclosed_preserved_pair:
      forall p S G,
      Gclosed S G ->
      Gclosed S (p :: G).
intros.
replace G with (app nil G). rewrite app_comm_cons.
apply Gclosed_preserved_env. assumption.
simpl. reflexivity.
Qed.

Lemma Gclosed_preserved:
      forall D S x Q G P,
      Gclosed S (D ++ (x, Q) :: G) ->
      Gclosed S (D ++ (x, P) :: G).
unfold Gclosed. destruct D. 

simpl. intros.
elim (LEM_Var x0 x).

intro. rewrite H1.
exists P. apply isinG_inside with (D := nil).

intro. elim (H x0); clear H. intro T; intros.
exists T. apply checkG. right.
inversion_clear H. inversion_clear H2. 
inversion_clear H. contradiction.
assumption. assumption.

simpl. intros.
elim (H x0); clear H. intro T; intros.
inversion_clear H. inversion_clear H1.
inversion_clear H. rewrite H1.
exists U. apply isinG_inside with (D := nil).

elim (LEM_Var x0 x).

intro. rewrite H1.
exists P. apply isinG_inside with (D := (y, U) :: D).

intro. exists T. apply checkG. right.
apply isinG_somewhere with Q. assumption. assumption. assumption.
Qed.

Lemma Gclosed_preserved_pair2:
      forall D S G x T,
      Gclosed S (D ++ G) ->
      Gclosed S (D ++ (x, T) :: G).
destruct D. 

simpl. intros.
apply Gclosed_preserved_pair. assumption.

unfold Gclosed. destruct p. simpl. intros.
elim (H x0); clear H. intro U; intros.

elim (LEM_Var x0 x).

intro. rewrite H1.
exists T. apply isinG_inside with (D := (v, t) :: D).

intro. exists U.
inversion_clear H. inversion_clear H2.
inversion_clear H. rewrite H2. rewrite H3.
apply checkG. left. tauto.
apply checkG. right.
apply isinG_neq2. assumption. assumption.
assumption.
Qed.

(* Permutations *)

Lemma Gfresh_permutation:
      forall G D x,
      Permutation G D -> Gfresh x G -> 
      Gfresh x D.
induction 1.

tauto.

destruct x0. intros.
inversion_clear H0. apply GfGrow.
apply IHPermutation. assumption. assumption.

destruct y. destruct x0. intros.
inversion_clear H. inversion_clear H0.
apply GfGrow. apply GfGrow.
assumption. assumption. assumption.

intro. apply IHPermutation2. apply IHPermutation1. assumption.
Qed.

Lemma isinG_permutation:
      forall G D x U,
      Permutation G D -> isinG x U G -> 
      isinG x U D.
induction 1.

tauto.

destruct x0. intros.
inversion_clear H0. inversion_clear H1.
inversion_clear H0. rewrite H1. rewrite H2.
apply isinG_inside with (D := nil).
apply checkG. right.
apply IHPermutation. assumption.

destruct y. destruct x0. intros.
inversion_clear H. inversion_clear H0.
inversion_clear H. rewrite H0. rewrite H1.
assert ((v0, t0)::(v, t)::l = ((v0, t0)::nil) ++ ((v, t)::l)). auto.
rewrite H. apply isinG_inside with (D := (v0, t0) :: nil).
inversion_clear H. inversion_clear H0.
inversion_clear H. rewrite H0. rewrite H1.
apply isinG_inside with (D := nil).
apply checkG. right.
apply checkG. right. assumption.

intro. apply IHPermutation2. apply IHPermutation1. assumption.
Qed.

Lemma Gclosed_permutation:
      forall G D S,
      Permutation G D -> Gclosed S G -> 
      Gclosed S D.
unfold Gclosed. induction 1.

tauto.

destruct x. intros.
elim (H0 x); clear H0. intro T; intros.
elim (LEM_Var x v).
intro. rewrite H2.
exists t. apply isinG_inside with (D := nil).
intro. exists T.
inversion_clear H0. inversion_clear H3.
inversion_clear H0. contradiction.
apply checkG. right.  
apply isinG_permutation with l. assumption. assumption.
assumption.

destruct y. destruct x. intros.

elim (H x); clear H. intro T; intros.
elim (LEM_Var x v).
intro. rewrite H1. exists t.
assert ((v0, t0)::(v, t)::l = ((v0, t0)::nil) ++ ((v, t)::l)). auto.
rewrite H2. apply isinG_inside with (D := (v0, t0) :: nil).
intro. exists T.
inversion_clear H. inversion_clear H2.
inversion_clear H. contradiction.
assert ((v0, t0)::(v, t)::l = ((v0, t0)::nil) ++ ((v, t)::l)). auto.
rewrite H2. apply isinG_neq2. assumption. assumption.
assumption.

intros. elim (H1 x). intro T; intros. exists T.
apply isinG_permutation with l'. assumption.
apply isinG_permutation with l. assumption. assumption.
assumption.
Qed.

(* okEnv *)

Lemma okEnv_derived2:
      forall D G T S x,
      subGTp G T S ->
      okEnv ((x, T) :: D ++ G) ->
      okEnv (D ++ (x, T) :: G).
induction D.

intros. simpl. simpl in H0. assumption.

case a; clear a. intros y U; intros.
inversion_clear H0. inversion_clear H1. inversion_clear H2.
rewrite <- app_comm_cons. apply okGrow.

apply IHD with S.
assumption. 
apply okGrow.
assumption.
apply Gfresh_preserved2 with (cons (y, U) nil).
simpl. apply GfGrow. assumption. assumption.
apply Gclosed_preserved_env.
assert (Gclosed T G /\ Gclosed S G). apply Gclosed_lemma. assumption.
tauto.

apply Gfresh_preserved3. assumption. assumption.

apply Gclosed_preserved_pair2. assumption.
Qed.

Lemma okEnv_permutation:
      forall x T G D,
      okEnv ((x, T) :: G) -> Permutation G D -> okEnv D -> 
      okEnv ((x, T) :: D).
intros.
inversion_clear H. apply okGrow.
assumption.
apply Gfresh_permutation with G. assumption. assumption. 
apply Gclosed_permutation with G. assumption. assumption.
Qed.

Lemma subGTp_permutation:
      forall G S T,
      subGTp G S T ->
      forall D, Permutation G D -> okEnv D ->
      subGTp D S T.
induction 1.

intros. apply subG_top. assumption.
apply Gclosed_permutation with G. assumption. assumption.

intros. apply subG_var with U. assumption.
apply isinG_permutation with G. assumption. assumption.

intros. apply subG_trs with U.
apply isinG_permutation with G. assumption. assumption.
apply IHsubGTp. assumption. assumption.

intros. apply subG_arr.
apply IHsubGTp1. assumption. assumption.
apply IHsubGTp2. assumption. assumption.

intros. apply subG_fa.
apply IHsubGTp. assumption. assumption.
intros. clear IHsubGTp H0.
apply H1.
apply okEnv_permutation with D. assumption.
apply Permutation_sym. assumption.
apply subGTp_ensures_okEnv with T1 S1. assumption.

apply perm_skip. assumption.

assumption.
Qed.

Lemma permutation:
      forall D G: list (Var * Tp), forall p: (Var * Tp),
      Permutation (D ++ p :: G) (p :: D ++ G).

intros. apply Permutation_sym.
apply Permutation_cons_app. apply Permutation_refl.
Qed.

Lemma okEnv_derived:
      forall G T S x D,
      subGTp G T S ->
      okEnv ((x, T) :: D ++ G) ->
      okEnv ((x, T) :: G).

intros. inversion_clear H0.
clear H3. apply okGrow.

apply subGTp_ensures_okEnv with T S. assumption.
apply Gfresh_preserved2 with D. assumption.

assert (Gclosed T G /\ Gclosed S G).
apply Gclosed_lemma. assumption.
tauto.
Qed.

(* Weakening *)

Lemma weakening:
      forall G S T D,
      subGTp G S T -> okEnv (app D G) ->
      subGTp (app D G) S T.
induction 1.

intros. apply subG_top.
assumption. 

apply Gclosed_preserved_env. assumption.

intros. apply subG_var with U. 
assumption. 

apply isinG_preserved. assumption.

intros. apply subG_trs with U.
apply isinG_preserved. assumption.
apply IHsubGTp. assumption.

intros. apply subG_arr.
apply IHsubGTp1. assumption.
apply IHsubGTp2. assumption.

intros. apply subG_fa.
apply IHsubGTp. assumption.

intros. clear H0 IHsubGTp H2.

assert (okEnv ((x, T1) :: G)).
apply okEnv_derived with S1 D. assumption. assumption.

assert (okEnv (D ++ (x, T1) :: G)).
apply okEnv_derived2 with S1. assumption. assumption.

assert (subGTp (D ++ (x, T1) :: G) (S2 x) (T2 x)).
apply H1. assumption. assumption.

clear H H1 H0 H2.

apply subGTp_permutation with (D ++ (x, T1) :: G).
assumption.

apply permutation.
assumption.
Qed.

(* Other preliminary properties *)

Lemma subGTp_preserves_okEnv:
      forall D x Q G P,
      okEnv (D ++ (x, Q) :: G) -> (subGTp G P Q) ->
      okEnv (D ++ (x, P) :: G).
induction D.

simpl. intros.
inversion_clear H.
apply okGrow.
assumption. assumption. 

assert (Gclosed P G /\ Gclosed Q G).
apply Gclosed_lemma. assumption. tauto.

intros.
inversion_clear H. rewrite <- app_comm_cons.
apply okGrow.
apply IHD with Q. assumption. assumption.

apply Gfresh_preserved with Q. assumption. 

apply Gclosed_preserved with Q. assumption.
Qed.

Lemma subGTp_preserves_okEnv2:
      forall D x P G Q,
      okEnv (D ++ (x, P) :: G) -> (subGTp G P Q) ->
      okEnv (D ++ (x, Q) :: G).
induction D.

simpl. intros.
inversion_clear H.
apply okGrow.
assumption. assumption. 

assert (Gclosed P G /\ Gclosed Q G). apply Gclosed_lemma. assumption.
tauto.

simpl. intros.
inversion_clear H.
apply okGrow.
apply IHD with P. assumption. assumption.

apply Gfresh_preserved with P. assumption. 

apply Gclosed_preserved with P. assumption.
Qed.