
(* Typing Environment and its Well-fordmedness - deep version *)

Require Import List.

Definition envTp: Set := (list (Var * Tp)).

Inductive Gfresh (x:Var): envTp -> Prop :=
          GfVoid: Gfresh x nil
        | GfGrow: forall G:envTp, forall y:Var, forall T:Tp,
                  Gfresh x G -> ~x=y ->
                  Gfresh x (cons (y,T) G).

Inductive isinG (x:Var) (T:Tp): envTp -> Prop :=
          checkG: forall G:envTp, forall y:Var, forall U:Tp,
                  (x=y /\ T=U) \/ isinG x T G ->
                  isinG x T (cons (y,U) G).

Definition Gclosed (T:Tp) (G:envTp): Prop :=
           forall x:Var,
           (isin x T) -> exists U:Tp, isinG x U G.


Inductive okEnv: envTp -> Prop :=
          okVoid: okEnv nil
        | okGrow: forall G:envTp, forall x:Var, forall T:Tp,
                  okEnv G ->
                  Gfresh x G -> Gclosed T G ->
                  okEnv (cons (x,T) G).

(* Occur checking predicates for envTp *)

Inductive notin_envTp (x : Var) : envTp -> Prop :=
    notin_void : notin_envTp x nil
  | notin_grow : forall (G : envTp) (y : Var) (U: Tp),
                 x <> y -> notin_envTp x G -> notin x U ->
                 notin_envTp x ((y,U) :: G).

Definition notin_envTp_ho:= fun (x : Var) (G : Var -> envTp) =>
           forall y : Var, x <> y -> notin_envTp x (G y).

(* Subtyping predicate - deep version *)   

Inductive subGTp: envTp -> Tp -> Tp -> Prop :=

          subG_top: forall G: envTp, forall S: Tp,
                   okEnv G -> Gclosed S G ->
                   subGTp G S top

        | subG_var: forall G: envTp, forall x: Var, forall U: Tp,
                   okEnv G -> isinG x U G ->
                   subGTp G x x

        | subG_trs: forall G: envTp, forall x: Var, forall U T: Tp,
                   isinG x U G -> subGTp G U T ->
                   subGTp G x T

        | subG_arr: forall G: envTp, forall S1 S2 T1 T2: Tp,
                   subGTp G T1 S1 -> subGTp G S2 T2 ->
                   subGTp G (arr S1 S2) (arr T1 T2)

        | subG_fa : forall G: envTp,
                   forall S1 T1: Tp, forall S2 T2: Var->Tp,
                   subGTp G T1 S1 ->
                   (forall x:Var, okEnv (cons (x,T1) G) ->
                                  subGTp (cons (x,T1) G) (S2 x) (T2 x)) ->
                   subGTp G (fa S1 S2) (fa T1 T2).
