
(* Auxiliary functions: from envTp to bookkeeping assumptions *)

Fixpoint envTp2envBook (G:envTp):=
match G with
  | nil => nil
  | (X,T)::G' => (cons (envBook X T) (envTp2envBook G'))
end.

Fixpoint book2Prop (B:list(Prop)):=
match B with
  | nil => True
  | (H::G') => H /\ (book2Prop G')
end.

(* Auxiliary lemmas: from deep to shallow *)

Lemma isinG2envBook: forall G: envTp, forall x: Var, forall U: Tp, isinG x U G -> (book2Prop (envTp2envBook G)) -> (envBook x U).

Proof.

induction G; intros.
 inversion_clear H.

 inversion H.
 inversion_clear H2.
  inversion_clear H4.
  rewrite <- H1 in H0.
  simpl in H0.
  rewrite H2; rewrite H5; tauto.

  apply IHG; auto.
  rewrite <- H1 in H0; simpl in H0; tauto.

Qed.

Lemma Gclosed2closed: forall S: Tp, forall G: envTp, Gclosed S G -> (book2Prop (envTp2envBook G)) -> closed S.

Proof.

induction S; unfold Gclosed; unfold closed; intros.
 inversion_clear H1.

 inversion H1.
 assert (exists U : Tp, isinG x U G).
  apply H; auto.

  inversion_clear H2.
  exists x0; apply isinG2envBook with G; auto.
  rewrite <- H3; assumption.

 assert (exists U : Tp, isinG x U G).
  apply H; assumption.

  inversion_clear H2.
  exists x0.
  inversion_clear H1.
  inversion_clear H2.
   apply isinG2envBook with G; auto.

   apply isinG2envBook with G; auto.

 assert (exists U : Tp, isinG x U G).
  apply H0; assumption.

  inversion_clear H3.
  exists x0.
  apply isinG2envBook with G; assumption.

Qed.

(* Internal Adequacy: from deep to shallow *)

Lemma exp2imp: forall G: envTp, forall S T: Tp, subGTp G S T -> (book2Prop (envTp2envBook G)) -> subTp S T.

Proof.

induction 1; intros.

apply sub_top; auto.
apply Gclosed2closed with G; auto.

apply sub_var with U; auto.
apply isinG2envBook with G; auto.

apply sub_trs with U; auto.
apply isinG2envBook with G; auto.

apply sub_arr; auto.

 apply sub_fa with (envTp2list G); intros.
  apply IHsubGTp; auto.

  apply H1; auto.
   apply okGrow.
    apply subGTp_ensures_okEnv with T1 S1; auto.

    apply freshList; auto.

    assert (Gclosed T1 G /\ Gclosed S1 G).
     apply Gclosed_lemma; auto.

     tauto.

   simpl.
   tauto.

Qed.