
(* Main proofs: reflexivity and transitivity-narrowing *)

Lemma reflexivity: forall T:Tp, forall G: envTp,
      okEnv G -> Gclosed T G -> subGTp G T T.
induction T; intros.
 apply subG_top.
  assumption.
 assumption.
unfold Gclosed in H0.
  cut (exists U : Tp, isinG v U G); [ intro | apply H0; apply isin_var ].
  inversion_clear H1.
  apply subG_var with x; auto.
apply subG_arr.
 apply IHT1; auto.
   unfold Gclosed in |- *; unfold Gclosed in H0; intros.
   apply H0.
   apply isin_arr; left; assumption.
apply IHT2; auto.
  unfold Gclosed in |- *; unfold Gclosed in H0; intros; apply H0;
   apply isin_arr; right; assumption.
apply subG_fa; intros.
 apply IHT; auto.
   unfold Gclosed in |- *; unfold Gclosed in H1; intros; apply H1.
   apply isin_fa; left; assumption.
apply H; auto.
  unfold Gclosed in |- *; intros.
  unfold Gclosed in H1.
  inversion H2.
  elim (LEM_Var x x0); intros.
 rewrite <- H10 in |- *; exists T.
   apply checkG; left; auto.
cut (exists U : Tp, isinG x0 U G); [ intro | apply H1; auto ].
 inversion H11.
   exists x2; apply checkG; right; assumption.
apply isin_fa; right; intros.
  apply isin_mono with x; auto.
Qed.

Lemma trans_var: forall G: envTp, forall x:Var, forall S Q: Tp, 
      Q=x -> subGTp G S Q -> 
      forall T: Tp, subGTp G Q T -> subGTp G S T.
induction 2; intros.
inversion H2.
apply subG_top; auto.
assumption.
apply subG_trs with U; auto.
inversion_clear H.
inversion_clear H.
Qed.

Lemma trans_arr: forall G: envTp, forall Q1 Q2 S: Tp, 
      (forall (S : Tp) (G : envTp),
       subGTp G S Q1 -> forall T : Tp, subGTp G Q1 T -> subGTp G S T) ->
      (forall (S : Tp) (G : envTp),
       subGTp G S Q2 -> forall T : Tp, subGTp G Q2 T -> subGTp G S T) ->
      subGTp G S (arr Q1 Q2) ->
      forall T : Tp, subGTp G (arr Q1 Q2) T -> subGTp G S T.
intros.
cut
 (forall Q S : Tp, forall G: envTp,
  Q = arr Q1 Q2 -> subGTp G S Q -> forall T : Tp, subGTp G Q T -> subGTp G S T);
 [ intros; apply H3 with (arr Q1 Q2); auto | idtac ].
  induction 2; intros.
 inversion_clear H3.
assumption.
rewrite H3 in H5; rewrite H3 in H6.
 inversion H6.
 apply subG_top; auto.
   unfold Gclosed in |- *; intros.
   inversion H12.
   exists U; assumption.
apply subG_trs with U; auto.
  apply IHsubGTp; auto.
  rewrite H3 in |- *.
  apply subG_arr; auto.
  inversion H4.
 apply subG_top; auto.
   cut (Gclosed T1 G0 /\ Gclosed S1 G0); [ intro | apply Gclosed_lemma; auto ].
   cut (Gclosed S2 G0 /\ Gclosed T2 G0); [ intro | apply Gclosed_lemma; auto ].
   inversion_clear H10; inversion_clear H11; unfold Gclosed in |- *; intros.
   inversion_clear H11.
   inversion_clear H15.
  unfold Gclosed in H13.
    apply H13; auto.
 unfold Gclosed in H10; apply H10; auto.
apply subG_arr.
inversion H3; apply H; auto.
rewrite <- H12; assumption.
rewrite <- H12; assumption.
inversion H3; apply H0; auto.
rewrite <-H13; assumption.
rewrite <-H13; assumption.
inversion_clear H3.
Qed.

Lemma trans_fa: forall (S : Tp) (G : envTp) (Q : Tp) (t : Var -> Tp),
(forall v : Var,
 forall (S : Tp) (G : envTp),
 subGTp G S (t v) -> forall T : Tp, subGTp G (t v) T -> subGTp G S T) ->

(forall (S : Tp) (G : envTp),
 subGTp G S Q -> forall T : Tp, subGTp G Q T -> subGTp G S T) ->
      
(forall (G' : envTp) (M N : Tp),
 subGTp G' M N ->
 forall (D : list (Var * Tp)) (x : Var) (G : list (Var * Tp)) (P : Tp),
 G' = D ++ (x, Q) :: G -> subGTp G P Q -> subGTp (D ++ (x, P) :: G) M N) ->
subGTp G S (fa Q t) -> forall T : Tp, subGTp G (fa Q t) T -> subGTp G S T.
intros.
cut
 (forall R S : Tp, forall G: envTp,
  R = fa Q t -> subGTp G S R -> forall T : Tp, subGTp G R T -> subGTp G S T);
 [ intros; apply H4 with (fa Q t); auto | idtac ].
induction 2; intros.
 inversion_clear H4.
 inversion_clear H4.
  rewrite H4 in H6; rewrite H4 in H7.
  apply subG_trs with U; auto.
  apply IHsubGTp; auto.
  rewrite H4 in |- *; assumption.
inversion_clear H4.

inversion H4.
inversion H8.

 apply subG_top; auto.
   unfold Gclosed in |- *; intros.
   inversion_clear H16.
   inversion_clear H17.
  cut (Gclosed T1 G0 /\ Gclosed S1 G0); [ intro | apply Gclosed_lemma; auto ].
    inversion_clear H17.
    unfold Gclosed in H19; apply H19; auto.
 elim (unsatG ((x, T1) :: G0)); intros.
   cut (subGTp ((x0, T1) :: G0) (S2 x0) (T2 x0)); [ intro | apply H6; auto ].
  cut (Gclosed (S2 x0) ((x0, T1) :: G0) /\ Gclosed (T2 x0) ((x0, T1) :: G0));
   [ intro | apply Gclosed_lemma; auto ].
   inversion_clear H19.
     unfold Gclosed in H20.
     cut (exists U : Tp, isinG x U ((x0, T1) :: G0));
      [ intro | apply H20; auto ].
    inversion_clear H19.
      inversion_clear H22.
      inversion_clear H19.
     inversion_clear H17; inversion_clear H22.
        absurd (x = x0).
      auto.
     auto.
    exists x1; assumption.
   inversion_clear H17; apply H16; auto.
  apply okGrow; intros; auto.
   inversion_clear H17; auto.
  cut (Gclosed T1 G0 /\ Gclosed S1 G0); [ intro | apply Gclosed_lemma; auto ].
     tauto.

apply subG_fa; intros.
 apply H0; auto.
    rewrite <- H10 in |- *; assumption.
   rewrite <- H10 in |- *; assumption.
cut (subGTp ((x, T1) :: G0) (S2 x) (T2 x)); [intro | apply H6; auto].
cut (subGTp (nil ++ (x, T3) :: G0) (S2 x) (T2 x)); [intro | apply H1 with (nil ++ (x, T1) :: G0); auto].
simpl in H19; apply (H x); auto.
rewrite <-H11; assumption.
rewrite <-H11; apply H16; auto.
rewrite <-H10; trivial.
rewrite <-H10; assumption.
apply okGrow; auto.
inversion_clear H17; auto.
inversion_clear H17; auto.
cut (Gclosed T3 G0 /\ Gclosed T1 G0); [intro | apply Gclosed_lemma; auto].
tauto.
Qed.

(* A logical tautology *)

Lemma mpx: forall A B: Prop,
           A -> (A -> B) ->
           A /\ B.
intros. split.
assumption. 
apply H0. assumption.
Qed.

(*******************************************************)

Theorem challenge_1A: forall Q: Tp,

(forall S: Tp, forall G: envTp, subGTp G S Q -> 
               forall T: Tp, subGTp G Q T -> subGTp G S T)
/\
(forall G':envTp, forall M N: Tp, subGTp G' M N ->
                  forall D x G P, 
                  G'=(app D (cons (x,Q) G)) ->
                  subGTp G P Q ->
                  subGTp (app D (cons (x,P) G)) M N).

Proof.

induction Q.

(************************* TOP *************************)

split.

(*** Trans: top case ***)

intros.   inversion H0.
   apply subG_top; auto.
   cut (Gclosed S G /\ Gclosed top G); [ intro | apply Gclosed_lemma; auto ].
    tauto.

(*** Narrow: top case ***)

induction 1.

(* top-top *)

intros. rewrite H1 in H, H0; clear H1. clear G.

apply subG_top.

apply subGTp_preserves_okEnv with top. assumption. assumption.

apply Gclosed_preserved with top. assumption.

(* top-var *)

intros. rewrite H1 in H, H0; clear H1. clear G.
elim (LEM_Var x x0).

intro. rewrite H1. 
apply subG_var with P.
apply subGTp_preserves_okEnv with top. assumption. assumption.
apply isinG_inside.

intro.
apply subG_var with U.
apply subGTp_preserves_okEnv with top. assumption. assumption.
apply isinG_somewhere with top. assumption. assumption.

(* top-trs *)

intros. rewrite H1 in IHsubGTp, H, H0; clear H1. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H1. rewrite H1 in H, H0, IHsubGTp; clear H1 x0.
apply subG_trs with P.

apply isinG_inside.

rewrite (isinG_type x U D top G0) in H0.

inversion_clear H0.
apply subG_top.
apply subGTp_preserves_okEnv with top. assumption. assumption.

assert (Gclosed P G0 /\ Gclosed top G0).
apply Gclosed_lemma. assumption.

apply Gclosed_preserved_env. 

apply Gclosed_preserved_pair. tauto.

assumption. 

apply subGTp_ensures_okEnv with U T. assumption.

intro. 
apply subG_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 top. assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubGTp. reflexivity. assumption.

(* top-arr *)

intros. rewrite H1 in IHsubGTp1, IHsubGTp2; clear H1. clear G H H0. 

apply subG_arr.
apply IHsubGTp1. reflexivity. assumption.
apply IHsubGTp2. reflexivity. assumption.

(* top-fa *)

intros. rewrite H2 in H1, IHsubGTp, H, H0; clear H2. clear G. 

apply subG_fa.
apply IHsubGTp. reflexivity. assumption.
intros. apply H1 with (D0 := (x0,T1)::D).

apply subGTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.

(************************* VAR *************************)

apply mpx.

(*** Trans: var case ***)

intros. apply trans_var with v v; auto.

(*** Narrow: var case ***)

intro.
induction 1.

(* var-top *)

intros. rewrite H2 in H0, H1; clear H2. clear G.

apply subG_top.
apply subGTp_preserves_okEnv with v. assumption. assumption.

apply Gclosed_preserved with v. assumption.

(* var-var *)

intros. rewrite H2 in H0, H1; clear H2. clear G.
elim (LEM_Var x x0).

intro. rewrite H2. 
apply subG_var with P.
apply subGTp_preserves_okEnv with v. assumption. assumption.
apply isinG_inside.

intro.
apply subG_var with U.
apply subGTp_preserves_okEnv with v. assumption. assumption.
apply isinG_somewhere with v. assumption. assumption.

(* var-trs *)

intros. rewrite H2 in IHsubGTp, H0, H1; clear H2. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H2. rewrite H2 in H0, H1, IHsubGTp; clear H2 x0.
apply subG_trs with P.

apply isinG_inside.

apply H.
assert (G0 = (app nil G0)). simpl. reflexivity. rewrite H2; clear H2.
assert ((D ++ (x, P) :: nil ++ G0) = (D ++ (x, P) :: nil) ++ G0).
apply eq_sym. apply app_ass. rewrite H2; clear H2.

apply weakening. assumption. 

rewrite app_ass. apply subGTp_preserves_okEnv with v.

apply subGTp_ensures_okEnv with U T.
assumption. assumption.

assert (U = (var v)). 

rewrite (isinG_type x U D v G0).
reflexivity. assumption. 
apply subGTp_ensures_okEnv with U T. assumption.
rewrite H2 in IHsubGTp; clear H2.

apply IHsubGTp.
reflexivity. assumption. 

intro. 
apply subG_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 v. assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubGTp.
reflexivity. assumption.

(* var-arr *)

intros. rewrite H0 in IHsubGTp1, IHsubGTp2; clear H0. clear G H0_ H0_0. 

apply subG_arr.
apply IHsubGTp1. reflexivity. assumption.
apply IHsubGTp2. reflexivity. assumption.

(* var-fa *)

intros. rewrite H3 in H2, IHsubGTp, H0, H1; clear H3. clear G. 

apply subG_fa.
apply IHsubGTp. reflexivity. assumption.
intros.
assert ((forall (D0 : list (Var * Tp)) (x1 : Var) (G : list (Var * Tp)) (P : Tp),
       (x0, T1) :: D ++ (x, (var v)) :: G0 = D0 ++ (x1, (var v)) :: G ->
       subGTp G P v -> subGTp (D0 ++ (x1, P) :: G) (S2 x0) (T2 x0))).
apply H2.
apply subGTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.

apply H2 with (D0 := (x0,T1)::D).
apply subGTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.

(************************* ARR *************************)

apply mpx.

(*** Trans: arr case ***)

intros.
apply trans_arr with Q1 Q2. tauto. tauto.
assumption. assumption. 

(*** Narrow: arr case ***)

intro.
induction 1.

(* arr-top *)

clear IHQ1 IHQ2.
intros. rewrite H2 in H0, H1; clear H2. clear G.

apply subG_top.
apply subGTp_preserves_okEnv with (arr Q1 Q2). assumption. assumption.

apply Gclosed_preserved with (arr Q1 Q2). assumption.

(* arr-var *)

clear IHQ1 IHQ2. intros.
rewrite H2 in H0, H1; clear H2. clear G.
elim (LEM_Var x x0).

intro. rewrite H2. 
apply subG_var with P.
apply subGTp_preserves_okEnv with (arr Q1 Q2). assumption. assumption.
apply isinG_inside.

intro.
apply subG_var with U.
apply subGTp_preserves_okEnv with (arr Q1 Q2). assumption. assumption.
apply isinG_somewhere with (arr Q1 Q2). assumption. assumption.

(* arr-trs *)

clear IHQ1 IHQ2.
intros. rewrite H2 in IHsubGTp, H0, H1; clear H2. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H2. rewrite H2 in H0, H1, IHsubGTp; clear H2 x0.
apply subG_trs with P.

apply isinG_inside.

apply H.

assert (G0 = (app nil G0)). simpl. reflexivity. rewrite H2; clear H2.
assert ((D ++ (x, P) :: nil ++ G0) = (D ++ (x, P) :: nil) ++ G0).
apply eq_sym. apply app_ass. rewrite H2; clear H2.

apply weakening. assumption. 

rewrite app_ass. apply subGTp_preserves_okEnv with (arr Q1 Q2).

apply subGTp_ensures_okEnv with U T.
assumption. assumption.

assert (U = (arr Q1 Q2)). 

rewrite (isinG_type x U D (arr Q1 Q2) G0).
reflexivity. assumption. 
apply subGTp_ensures_okEnv with U T. assumption.
rewrite H2 in IHsubGTp; clear H2.

apply IHsubGTp.
reflexivity. assumption. 

intro. 
apply subG_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 (arr Q1 Q2). assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubGTp. reflexivity. assumption.

(* arr-arr *)

clear IHQ1 IHQ2.
intros. rewrite H0 in IHsubGTp1, IHsubGTp2; clear H0. clear G H0_ H0_0. 

apply subG_arr.
apply IHsubGTp1. reflexivity. assumption.
apply IHsubGTp2. reflexivity. assumption.

(* arr-fa *)

clear IHQ1 IHQ2.
intros. rewrite H3 in H2, IHsubGTp, H0, H1; clear H3. clear G. 

apply subG_fa.
apply IHsubGTp. reflexivity. assumption.
intros.
assert ((forall (D0 : list (Var * Tp)) (x1 : Var) (G : list (Var * Tp)) (P : Tp),
       (x0, T1) :: D ++ (x, (arr Q1 Q2)) :: G0 = D0 ++ (x1, (arr Q1 Q2)) :: G ->
       subGTp G P (arr Q1 Q2) -> subGTp (D0 ++ (x1, P) :: G) (S2 x0) (T2 x0))).
apply H2.
apply subGTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.

apply H2 with (D0 := (x0,T1)::D).
apply subGTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.

(************************* FA *************************)

apply mpx.

(*** Trans: fa case ***)

do 2 intro. apply trans_fa.
intro. elim (H v). tauto. 
apply IHQ. apply IHQ.

(*** Narrow: fa case ***)

intro.
induction 1.

(* fa-top *)

clear IHQ H.
intros. rewrite H in H1, H2; clear H. clear G.

apply subG_top.
apply subGTp_preserves_okEnv with (fa Q t). assumption. assumption.

apply Gclosed_preserved with (fa Q t). assumption.

(* fa-var *)

clear IHQ H.
intros. rewrite H in H1, H2; clear H. clear G.
elim (LEM_Var x x0).

intro. rewrite H. 
apply subG_var with P.
apply subGTp_preserves_okEnv with (fa Q t). assumption. assumption.
apply isinG_inside.

intro.
apply subG_var with U.
apply subGTp_preserves_okEnv with (fa Q t). assumption. assumption.
apply isinG_somewhere with (fa Q t). assumption. assumption.

(* fa-trs *)

clear IHQ H.
intros. rewrite H in IHsubGTp, H1, H2; clear H. clear G.

elim (LEM_Var x0 x). 

intro. rewrite H. rewrite H in H1, H2, IHsubGTp; clear H x0.
apply subG_trs with P.

apply isinG_inside.

apply H0.

assert (G0 = (app nil G0)). simpl. reflexivity. rewrite H; clear H.
assert ((D ++ (x, P) :: nil ++ G0) = (D ++ (x, P) :: nil) ++ G0).
apply eq_sym. apply app_ass. rewrite H; clear H.

apply weakening. assumption. 

rewrite app_ass. apply subGTp_preserves_okEnv with (fa Q t).

apply subGTp_ensures_okEnv with U T.
assumption. assumption.

assert (U = (fa Q t)). 

rewrite (isinG_type x U D (fa Q t) G0).
reflexivity. assumption. 
apply subGTp_ensures_okEnv with U T. assumption.
rewrite H in IHsubGTp; clear H.

apply IHsubGTp.  
reflexivity. assumption. 

intro. 
apply subG_trs with U. 

assert (isinG x U (D ++ G0)). apply isinG_neq with x0 (fa Q t). assumption. auto. 
apply isinG_neq2. assumption. auto.
apply IHsubGTp. reflexivity. assumption.

(* fa-arr *)

clear H IHQ.
intros. rewrite H in IHsubGTp1, IHsubGTp2; clear H. clear G H1_ H1_0. 

apply subG_arr.
apply IHsubGTp1. reflexivity. assumption.
apply IHsubGTp2. reflexivity. assumption.

(* fa-fa *)

clear H IHQ.
intros. rewrite H in H2, IHsubGTp, H1, H3; clear H. clear G. 

apply subG_fa.
apply IHsubGTp. reflexivity. assumption.
intros.
assert ((forall (D0 : list (Var * Tp)) (x1 : Var) (G : list (Var * Tp)) (P : Tp),
       (x0, T1) :: D ++ (x, (fa Q t)) :: G0 = D0 ++ (x1, (fa Q t)) :: G ->
       subGTp G P (fa Q t) -> subGTp (D0 ++ (x1, P) :: G) (S2 x0) (T2 x0))).
apply H3.
apply subGTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.

apply H3 with (D0 := (x0,T1)::D).
apply subGTp_preserves_okEnv2 with (D := (x0,T1)::D) (P := P). assumption. assumption.
reflexivity. assumption.
Qed.