
Require Import Omega.

(* Starting properties *)

Lemma Sep: forall T: Tp, forall X Y: Var, isin X T -> notin Y T -> ~(X=Y).
induction T; intros; auto.
inversion_clear H.
inversion H.
rewrite <-H2 in H0; inversion H0.
rewrite <-H2; auto.
inversion_clear H0; inversion_clear H.
inversion H0.
apply IHT1; auto.
apply IHT2; auto.
inversion_clear H1; inversion_clear H0.
inversion H1.
apply IHT; auto.
elim (unsat (arr X Y)); intros.
inversion_clear H4.
inversion_clear H5; inversion_clear H6.
apply H with x; auto.
Qed.

Lemma isin_not_notin: forall T: Tp, forall X: Var, isin X T -> ~ notin X T.
unfold not; intros.
absurd (X = X).
apply Sep with T; auto.
trivial.
Qed.

Lemma notin_not_isin: forall T: Tp, forall X: Var, notin X T -> ~ isin X T.
unfold not; intros.
absurd (X = X).
apply Sep with T; auto.
trivial.
Qed.

Inductive lntp: Tp -> nat -> Prop:=
    lntp_top : (lntp top (S O))
  | lntp_var : forall x: Var,
               (lntp x (S O))
  | lntp_arr : forall s t: Tp, forall n1 n2: nat,
               (lntp s n1) -> (lntp t n2) ->
               (lntp (arr s t) (S (plus n1 n2)))
  | lntp_fa  : forall s: Tp, forall t: Var -> Tp, forall n1 n2:nat,
               (lntp s n1) -> (forall x:Var, (lntp (t x) n2)) ->
               (lntp (fa s t) (S (plus n1 n2))).

Section nat_ind_complete.

Lemma NAT_COMPLETE: forall P: nat->Prop,
                    (forall n: nat, (forall m: nat, (lt m n) -> (P m)) -> (P n)) ->
                    forall a b: nat, (lt b a) -> (P b).
do 2 intro.
induction a; intros.
inversion_clear H0.
inversion_clear H0.
apply H; intros; apply IHa; auto.
apply IHa; unfold lt; assumption.
Qed.

Lemma NAT_IND: forall P: nat->Prop,
               (P O) ->
               (forall n: nat, (forall m: nat, (lt m n) -> (P m)) -> (P n)) ->
               (forall n: nat, (P n)).
do 3 intro; induction n; intros.

assumption.

apply H0; intros.
inversion H1.
assumption.
apply NAT_COMPLETE with (S m0); [assumption | rewrite H2; assumption].
Qed.

End nat_ind_complete.

Lemma LNTP_S: forall s: Tp, forall n: nat,
             (lntp s n) -> (lt O n).
induction s; intros.

inversion_clear H.
omega.
inversion_clear H.
omega.
inversion_clear H.
cut (lt (0) n1); [intro | apply IHs1; assumption].
cut (lt (0) n2); [intro | apply IHs2; assumption].
omega.

inversion_clear H0; elim (unsat s); intros.
cut (lt (0) n2); [intro | apply H with x; auto].
omega.
Qed.

Lemma LNTP_RW: forall n: nat, forall s:Tp, (lntp s n) -> forall x:Var, forall t: Var->Tp,
               (notin_ho x t) -> s=(t x) ->
               forall y: Var, (lntp (t y) n).
intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply LNTP_S with s; assumption].
inversion_clear H2.

inversion H0.

rewrite <-H3 in H2; cut (t=(fun z:Var => top)); [intro | apply tp_ext with x; [assumption | unfold notin_ho; intros; apply notin_top | rewrite H2; trivial]].
rewrite H5; apply lntp_top.

elim (LEM_Var x0 x); intros.
cut (t=var); [intro | apply tp_ext with x; [assumption | unfold notin_ho; intros; apply notin_var; assumption | rewrite <-H2; rewrite <-H3; rewrite H5; trivial]].
rewrite H6; apply lntp_var.
cut (t=(fun z:Var => x0)); [intro | apply tp_ext with x; [assumption | unfold notin_ho; intros; apply notin_var; auto | rewrite H3; auto]].
rewrite H6; apply lntp_var.

elim (tp_exp s0 x); elim (tp_exp t0 x); intros.
inversion_clear H7; inversion_clear H8.
rewrite <-H5 in H0; rewrite H10 in H0; rewrite H11 in H0; inversion H0.
rewrite H2 in H5; rewrite H10 in H5; rewrite H11 in H5; cut (t=(fun z:Var => (arr (x1 z) (x0 z)))); [intro | apply tp_ext with x; [assumption | unfold notin_ho; intros; apply notin_arr; [unfold notin_ho in H7; auto | unfold notin_ho in H9; auto] | rewrite H5; trivial]].
rewrite H16; apply lntp_arr.
apply H with s1 x; [omega | rewrite H8; rewrite <-H11; assumption | unfold notin_ho in H7; unfold notin_ho; intros; auto | assumption].
apply H with t1 x; [omega | rewrite H12; rewrite <-H10; assumption | unfold notin_ho in H9; unfold notin_ho; intros; auto | assumption].

elim (LEM_Var x y); intros.
rewrite <-H7; rewrite <-H2; rewrite H6; assumption.
elim (tp_exp s0 x); elim (ho_tp_exp t0 x); intros.
inversion_clear H8; inversion_clear H9.
rewrite <-H5 in H0; rewrite H11 in H0; rewrite H12 in H0; inversion H0.
rewrite H2 in H5; rewrite H11 in H5; rewrite H12 in H5; cut (t=(fun z:Var => fa (x1 z) (x0 z))); [intro | apply tp_ext with x].
rewrite H17; apply lntp_fa; intros.
elim (unsat (arr x (fa y t))); intros.
inversion_clear H18.
inversion_clear H19; inversion_clear H20.
inversion_clear H19.
apply H with (x1 x) x; [omega | rewrite <-H12; assumption | unfold notin_ho in H8; unfold notin_ho; intros; auto | trivial].
elim (unsat (arr x (arr y (fa x2 t)))); intros.
inversion_clear H18.
inversion_clear H19; inversion_clear H20.
inversion_clear H19; inversion_clear H21.
apply H with (x0 y x3) x3; [omega | idtac | rewrite H17 in H22; cut (notin x3 (fa (x1 y) (x0 y))); [intro | auto]; inversion_clear H21; unfold notin_ho; intros; auto | trivial].
change (lntp ((fun z:Var => (x0 z x3)) y) n2); apply H with (t0 x3) x; [omega | auto | unfold notin_ho in H10; unfold notin_ho; intros; cut (notin x (fa top (x0 y0))); [intro | auto]; inversion_clear H23; auto | rewrite H11; trivial].
assumption.
unfold notin_ho in H8; unfold notin_ho in H10; unfold notin_ho; intros.
cut (notin x (x1 y0)); [intro | auto].
cut (notin x (fa top (x0 y0))); [intro | auto].
inversion_clear H19.
apply notin_fa; intros; auto.
auto.
Qed.

Lemma LNTP_TOT: forall t:Tp,
                exists n:nat, (lntp t n).
induction t; intros.

exists (S O); apply lntp_top.

exists (S O); apply lntp_var.

inversion_clear IHt1; inversion_clear IHt2; intros.
exists (S (x + x0)); apply lntp_arr; assumption.

elim (unsat (fa t t0)); intros.
inversion_clear IHt; intros.
cut (exists n : nat, lntp (t0 x) n); [intro | auto].
inversion_clear H2.
exists (S (x0+x1)); apply lntp_fa; intros; auto.
apply LNTP_RW with (t0 x) x; auto.
inversion_clear H0; auto.
Qed.

Lemma pre_notin_mono: forall n:nat, forall T:Tp,
      (lntp T n) ->
      forall U:Var->Tp, forall z:Var, (notin_ho z U) -> T=(U z) ->
      forall x y:Var, (notin x (U y)) -> (notin_ho x U).
intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply LNTP_S with T; assumption].
inversion_clear H3.

inversion H0.

rewrite <-H4 in H2; cut (U=(fun z:Var => top)); [intro | apply tp_ext with z; try (apply notin_top; intros; apply notin_top); auto].
rewrite H6; unfold notin_ho; intros; apply notin_top.
unfold notin_ho; intros; apply notin_top.

elim (LEM_Var x0 z); intros.
 rewrite <- H4 in H2; rewrite H6 in H2.
   cut (U = var); [ intro | apply tp_ext with z; auto ].
  rewrite H7 in |- *; unfold notin_ho in |- *; intros; apply notin_var; auto.
 unfold notin_ho in |- *; intros; apply notin_var; auto.
rewrite <- H4 in H2.
  cut (U = (fun z : Var => x0)); [ intro | apply tp_ext with z; auto ].
 rewrite H7 in |- *; unfold notin_ho in |- *; intros; apply notin_var; auto.
   rewrite H7 in H3; inversion H3; auto.
unfold notin_ho in |- *; intros; apply notin_var; auto.

rewrite <-H6 in H2; elim (tp_exp s z); elim (tp_exp t z); intros.
inversion_clear H8; inversion_clear H9.
rewrite H11 in H2; rewrite H12 in H2.
cut (U=(fun z:Var => (arr (x1 z) (x0 z)))); [intro | apply tp_ext with z; try (unfold notin_ho in H8; unfold notin_ho in H10; unfold notin_ho; intros; apply notin_arr); auto].
rewrite H9; unfold notin_ho; intros; apply notin_arr.
cut (notin_ho x x1); [intro; unfold notin_ho in H14; auto | apply H with n1 (x1 z) z y; [rewrite <-H7; omega | apply LNTP_RW with (x1 z) z; [rewrite <-H12; assumption | assumption | trivial] | assumption | trivial | rewrite H9 in H3; inversion_clear H3; assumption]].
cut (notin_ho x x0); [intro; unfold notin_ho in H14; auto | apply H with n2 (x0 z) z y; [rewrite <-H7; omega | apply LNTP_RW with (x0 z) z; [rewrite <-H11; assumption | assumption | trivial] | assumption | trivial | rewrite H9 in H3; inversion_clear H3; assumption]].

rewrite <-H6 in H2; elim (tp_exp s z); elim (ho_tp_exp t z); intros.
inversion_clear H8; inversion_clear H9.
rewrite H11 in H2; rewrite H12 in H2.
cut (U=(fun z:Var => (fa (x1 z) (x0 z)))); [intro | apply tp_ext with z; auto].
rewrite H9; unfold notin_ho; intros; apply notin_fa; intros.
rewrite H9 in H3; inversion_clear H3.
cut (notin_ho x x1); [intro | auto].
unfold notin_ho in H3; auto.
apply H with n1 (x1 z) z y; auto.
omega.
rewrite <-H12; assumption.

elim (unsat (arr y1 (arr y0 (fa x (fun u:Var => (fa z (x0 u))))))); intros.
inversion_clear H15.
inversion_clear H16.
inversion_clear H17.
inversion_clear H16.
inversion_clear H18.
inversion_clear H16.

cut (notin_ho x (fun z:Var => (x0 z y1))); [intro; unfold notin_ho in H16; apply H16; auto | idtac].
apply H with n2 (x0 x2 y1) x2 y; auto.
omega.
elim (unsat (arr x2 (arr y1 (arr y0 (fa x (fun u:Var => (fa z (x0 u)))))))); intros.
inversion_clear H16.
inversion_clear H20.
inversion_clear H21.
inversion_clear H20.
inversion_clear H22.
inversion_clear H20.
inversion_clear H23.
inversion_clear H20.
apply LNTP_RW with (x0 x2 x3) x3; auto.
change (lntp ((fun z:Var => (x0 z x3)) x2) n2); apply LNTP_RW with (x0 z x3) z; auto.
rewrite <-H11; auto.
unfold notin_ho in H10; unfold notin_ho; intros.
cut (notin x3 (fa z (x0 x))); [intro | apply H24; auto].
inversion_clear H25; cut (notin z (fa top (x0 y2))); [intro | apply H10; auto].
inversion_clear H25; inversion_clear H26; auto.
cut (notin x3 (fa z (x0 x2))); [intro | auto].
inversion_clear H20; auto.
unfold notin_ho; intros.
cut (notin x2 (fa z (x0 y2))); [intro | auto].
inversion_clear H20; auto.
rewrite H9 in H3; inversion_clear H3; auto.
unfold notin_ho in H8; unfold notin_ho in H10; unfold notin_ho; intros.
cut (notin z (fa top (x0 y0))); [intro | apply H10; auto].
inversion_clear H13; apply notin_fa; intros; auto.
Qed.

Lemma notin_mono: forall T: Var->Tp, forall x y: Var,
                  (notin x (T y)) ->
                  (forall z: Var, ~x=z -> (notin x (T z))).
intros.
elim (unsat (fa top T)); intros.
inversion_clear H1; clear H2.
elim (LNTP_TOT (T x0)); intros.
apply pre_notin_mono with x1 (T x0) x0 y; auto.
Qed.

Lemma pre_isin_mono: forall n:nat, forall T:Tp,
      (lntp T n) ->
      forall U:Var->Tp, forall z:Var, (notin_ho z U) -> T=(U z) ->
      forall x y:Var, ~x=y -> (isin x (U y)) ->
      forall v:Var, ~x=v -> (isin x (U v)).
intro; pattern n; apply NAT_IND; intros.

cut (lt O (0)); [intro | apply LNTP_S with T; assumption].
inversion_clear H5.

inversion H0.

rewrite <-H6 in H2; cut (U=(fun z:Var => top)); [intro | apply tp_ext with z; try (apply notin_top; intros; apply notin_top); auto].
rewrite H8 in H4; inversion_clear H4.
unfold notin_ho; intros; apply notin_top.

elim (LEM_Var x0 z); intros.
 rewrite <- H6 in H2; rewrite H8 in H2.
   cut (U = var); [ intro | apply tp_ext with z; auto ].
rewrite H9 in H4; inversion H4.
absurd (x=y); auto.
unfold notin_ho in |- *; intros; apply notin_var; auto.
rewrite <- H6 in H2.
  cut (U = (fun z : Var => x0)); [ intro | apply tp_ext with z; auto ].
rewrite H9 in H4; rewrite H9; assumption.
unfold notin_ho in |- *; intros; apply notin_var; auto.

rewrite <-H8 in H2; elim (tp_exp s z); elim (tp_exp t z); intros.
inversion_clear H10; inversion_clear H11.
rewrite H13 in H2; rewrite H14 in H2.
cut (U=(fun z:Var => (arr (x1 z) (x0 z)))); [intro | apply tp_ext with z; try (unfold notin_ho in H10; unfold notin_ho in H12; unfold notin_ho; intros; apply notin_arr); auto].
rewrite H11; apply isin_arr.
rewrite H11 in H4; inversion H4.
inversion_clear H16.
left; apply H with n1 (x1 z) z y; auto.
omega.
rewrite <-H14; assumption.
right; apply H with n2 (x0 z) z y; auto.
omega.
rewrite <-H13; assumption.

rewrite <-H8 in H2; elim (tp_exp s z); elim (ho_tp_exp t z); intros.
inversion_clear H10; inversion_clear H11.
rewrite H13 in H2; rewrite H14 in H2.
cut (U=(fun z:Var => (fa (x1 z) (x0 z)))); [intro | apply tp_ext with z; auto].
rewrite H11; apply isin_fa.
rewrite H11 in H4; inversion H4.
inversion_clear H16.
left; apply H with n1 (x1 z) z y; auto.
omega.
rewrite <-H14; assumption.

right; intros; elim (unsat (arr v (arr y0 (fa x (fun u:Var => (fa z (x0 u))))))); intros.
inversion_clear H19.
inversion_clear H20.
inversion_clear H21.
inversion_clear H20.
inversion_clear H22.
inversion_clear H20.

cut (forall w:Var, ~x=w -> isin x ((fun z:Var => (x0 z y0)) w)); [intro; apply H20; auto | idtac].
intros; change (isin x ((fun z:Var => x0 z y0) w)); apply H with n2 (x0 x2 y0) x2 y; auto.
omega.
elim (unsat (arr x2 (arr v (arr y0 (fa x (fun u:Var => (fa z (x0 u)))))))); intros.
inversion_clear H24.
inversion_clear H25.
inversion_clear H26.
inversion_clear H25.
inversion_clear H27.
inversion_clear H25.
inversion_clear H28.
inversion_clear H25.
apply LNTP_RW with (x0 x2 x3) x3; auto.
change (lntp ((fun z:Var => (x0 z x3)) x2) n2); apply LNTP_RW with (x0 z x3) z; auto.
rewrite <-H13; auto.
unfold notin_ho in H12; unfold notin_ho; intros.
cut (notin x3 (fa z (x0 x))); [intro | apply H29; auto].
inversion_clear H30; cut (notin z (fa top (x0 y1))); [intro | apply H12; auto].
inversion_clear H30; inversion_clear H31; auto.
cut (notin x3 (fa z (x0 x2))); [intro | auto].
unfold notin_ho; intros; inversion_clear H25; auto.
unfold notin_ho; intros.
cut (notin x2 (fa z (x0 y1))); [intro | auto].
inversion_clear H25; auto.
unfold notin_ho in H10; unfold notin_ho in H12; unfold notin_ho; intros.
cut (notin z (fa top (x0 y0))); [intro | apply H12; auto].
inversion_clear H15; apply notin_fa; intros; auto.
Qed.

Lemma isin_mono: forall T: Var->Tp, forall x y: Var,
                 ~x=y -> (isin x (T y)) ->
                 (forall z: Var, ~x=z -> (isin x (T z))).
intros.
elim (unsat (fa top T)); intros.
inversion_clear H2; clear H3.
elim (LNTP_TOT (T x0)); intros.
apply pre_isin_mono with x1 (T x0) x0 y; auto.
Qed.

Lemma LEM_OC: forall x: Var, forall S: Tp, isin x S \/ notin x S.

Proof.

induction S; intros.
 right; apply notin_top.

 elim (LEM_Var x v); intros.
  left; rewrite H; apply isin_var.

  right; apply notin_var; auto.

 inversion_clear IHS1; inversion_clear IHS2.
  left; apply isin_arr; left; assumption.

  left; apply isin_arr; left; assumption.

  left; apply isin_arr; right; assumption.

  right; apply notin_arr; assumption.

 inversion_clear IHS.
  left; apply isin_fa; left; assumption.

  elim (unsat (arr x top)); intros.
  inversion_clear H1.
  inversion_clear H2; clear H3.
  elim (H x0); intros.
   left; apply isin_fa; right; intros.
   apply isin_mono with x0; auto.

   right; apply notin_fa; intros; auto.
   apply notin_mono with x0; auto.

Qed.

Lemma sepTp: forall x y: Var, forall S: Tp, isin x S -> notin y S -> x<>y.

Proof.

induction S; intros.
 inversion_clear H.

 inversion H; inversion H0; auto.

 inversion_clear H; inversion_clear H0; auto.
 inversion_clear H1; auto.

 inversion_clear H0; inversion_clear H1.
 inversion_clear H2; auto.
 elim (unsat (arr x y)); intros.
 inversion_clear H2.
 inversion_clear H4; inversion_clear H5.
 apply H with x0; auto.

Qed.
