/*
***************************************
By AGOSTINO DOVIER, UNIVERSITY OF UDINE
MAY 30, 2018
***************************************
*/

#include <stdio.h>
#include <stdlib.h>

#define n 9

int simple_parsing(char c, FILE *miofile){
  int sum=c-'0';
  char t = fgetc(miofile);
  while (47 <t  && t < 58){
       sum=sum*10+t-48;
       t = fgetc(miofile);
  }
  return sum;   
}

void leggilinea(FILE *miofile){
  char t = fgetc(miofile);
  while (t != 13 && t != 10) t = fgetc(miofile);
}

void filter(char *filename, int mat [n][n]){
  int temp;
  char t;
  FILE *miofile;

  if((miofile = fopen(filename,"r"))==NULL) {
     printf("File not found >%s< (premature exit)\n",filename); exit(-1);
  }
  else { 
    while(!feof(miofile)){
      t = fgetc(miofile);
      if (t=='S') leggilinea(miofile); // Skip comments
      else if (t=='-') temp = -simple_parsing(48,miofile); // Useless value
      else if ('0' < t  && t <= '9'){
         temp = simple_parsing(t, miofile);
         mat[(temp-1) / (n*n)][(temp-1) % (n*n) / n] = (temp-1) % n + 1; 
      } 
    }            
    fclose(miofile);     
  } // else  
}

int  main(int argc, char** argv) {
  int i,j,num_clauses;
  int mat [n][n];

  for(i=0; i < n; i++)
       for(j=0; j < n; j++)
	 mat[i][j]=0;

  // argv[1] is the filename
  filter(argv[1], mat);

  printf("*** SOLUZIONE ***\n");
  for(i=0; i < n; i++){
    for(j=0; j < n; j++)
      if( mat[i][j] > 0) printf("%d ",mat[i][j]);
      else printf("  ");  
      printf("|\n");
    }
       
  return 1;

}
        

