/*
***************************************
By AGOSTINO DOVIER, UNIVERSITY OF UDINE
MAY 30, 2018
***************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define n 9

void leggilinea(int i, FILE *miofile, int mat [n][n]){
  int j = 0;
  char t = fgetc(miofile);
  while (t != 13 && t != 10){  // Look for CR or NL
    if(47 <t  && t < 58){
        mat[i][j] = t-48;
        j++;
    }
    if(t == '_'){
        mat[i][j] = 0;
        j++;
    }
    t = fgetc(miofile);    
  }//while
}

void load_matrix(char *filename, int mat [n][n]){
  int i=0;
  FILE *miofile;

  if((miofile = fopen(filename,"r"))==NULL) {
     printf("File not found >%s< (premature exit)\n",filename); 
     exit(-1);
  } // then
  else  {
      for(i=0; i < n; i++)
          leggilinea(i, miofile, mat);
      fclose(miofile);     
  } // else  
}

int compute(int mat [n][n]){
  int i,j,sum;
  sum =  4*n*n*(1+(n*(n-1))/2);
  for(i=0;i<n;i++)
    for(j=0;j<n; j++)
      if(mat[i][j] > 0) sum++;
  return sum;
}

void exactly_one(int v [n]){
  int i,j;
  // at least one
  for(i=0;i<n;i++)
      printf("%d ",v[i]);
    printf(" 0 \n");
 // not two   
  for(i=0; i < n-1; i++)
    for(j=i+1; j < n; j++)
       printf("-%d -%d 0 \n",v[i],v[j]);
}

int  main(int argc, char** argv) {
  int row,col,bit,sq,temp;
  int mat [n][n];
  int eo [n];

  // argv[1] is the filename
  load_matrix(argv[1], mat);

  /*
  printf("*** SUDOKU IN INPUT ***\n");
  for(int i=0; i < n; i++){
       for(int j=0; j < n; j++)
	 printf("%d  ",mat[i][j]);
       printf("\n");
  }
  */

  printf("c SAT encoding of the SUDOKU\n");
  printf("c Variables 1..9 are for cell [1,1], 10..18 for [1,2], ... 721..729 for [9,9]\n");  
  printf("p cnf %d %d\n", n*n*n, compute(mat));

  // La cella (i,j) ha variabili da n^2*i + n*j + 1 ... n^2*i + n*j + n   
  
  // *** BOOLEAN MEANING ***
  // ***In every cell exactly one is true
  for(row=0; row < n; row++)
    for(col=0; col < n; col++) {
        for(bit=0; bit < n; bit++) eo[bit]=n*n*row+n*col+bit+1;
        exactly_one(eo);
    }
    
  // *** ALL DIFFERENT IN COLUMNS
  // *** In every column "bit" exactly one is true   
  for(col=0; col < n; col++)
    for(bit=0; bit < n; bit++){
        for(row=0; row < n; row++) eo[row]=n*n*row+n*col+bit+1;
	exactly_one(eo);
    }

  // *** ALL DIFFERENT IN ROWS
  for(row=0; row < n; row++)
    for(bit=0; bit < n; bit++){
       for(col=0; col < n; col++) eo[col]=n*n*row+n*col+bit+1;
       exactly_one(eo);
    }

  // *** ALL DIFFERENT IN SUBSQUARES
  // | 0   1   2 |
  // | 3   4   5 |
  // | 6   7   8 |
  temp = (int) sqrt(n);
  for(sq=0; sq < n; sq++) 
   for(bit=0; bit < n; bit++){
      for(row=0; row < temp; row++) 
	for(col=0; col < temp; col++) 
	  eo[row*temp+col]= n*n*(row + 3*(sq/temp))+n*(col+ 3*(sq % temp))+bit+1;
       exactly_one(eo);
    }

 // *** INPUT PART
  for(row=0; row < n; row++)
    for(col=0; col < n; col++)
      if (mat[row][col] > 0)
	printf("%d 0\n", n*n*row+n*col+mat[row][col]);

 
  return 1;

}
        

